/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.mixin.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import reborncore.common.misc.MultiBlockBreakingTool;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;

@Mixin(class_761.class)
public abstract class MixinWorldRenderer {

	@Shadow
	@Final
	private class_310 client;
	@Shadow
	private class_638 world;

	@Shadow
	private static void drawShapeOutline(class_4587 matrixStack, class_4588 vertexConsumer, class_265 voxelShape, double d, double e, double f, float g, float h, float i, float j) {
		throw new AssertionError();
	}

	@Inject(method = "drawBlockOutline", at = @At("HEAD"), cancellable = true)
	private void drawBlockOutline(class_4587 matrixStack, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 targetPos, class_2680 targetBlockState, CallbackInfo info) {
		List<class_265> shapes = new ArrayList<>();

		if (entity == client.field_1724) {
			class_746 clientPlayerEntity = client.field_1724;
			class_1799 stack = clientPlayerEntity.method_6047();
			if (stack.method_7960()) {
				return;
			}
			if (stack.method_7909() instanceof MultiBlockBreakingTool) {
				Set<class_2338> blockPosList = ((MultiBlockBreakingTool) stack.method_7909()).getBlocksToBreak(stack, clientPlayerEntity.field_6002, targetPos, clientPlayerEntity);

				for (class_2338 pos : blockPosList) {
					if (pos.equals(targetPos)) {
						continue;
					}

					class_2680 blockState = world.method_8320(pos);
					shapes.add(blockState.method_26172(world, pos, class_3726.method_16195(entity)).method_1096(pos.method_10263() - targetPos.method_10263(), pos.method_10264() - targetPos.method_10264(), pos.method_10260() - targetPos.method_10260()));

				}
			}
		}

		if (!shapes.isEmpty()) {
			class_265 shape = targetBlockState.method_26172(world, targetPos, class_3726.method_16195(entity));

			for (class_265 voxelShape : shapes) {
				shape = class_259.method_1084(shape, voxelShape);
			}

			drawShapeOutline(matrixStack, vertexConsumer, shape, (double)targetPos.method_10263() - d, (double)targetPos.method_10264() - e, (double)targetPos.method_10260() - f, 0.0F, 0.0F, 0.0F, 0.4F);
			//info.cancel(); // Enable to render a single bounding box around the whole thing
		}
	}

}
