/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util.serialization;

import com.google.gson.*;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;

//Based from ee3's code
public class ItemStackSerializer implements JsonSerializer<class_1799>, JsonDeserializer<class_1799> {

	private static final String NAME = "name";
	private static final String STACK_SIZE = "stackSize";
	private static final String TAG_COMPOUND = "tagCompound";

	@Override
	public class_1799 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {

		if (json.isJsonObject()) {

			JsonObject jsonObject = json.getAsJsonObject();

			String name = null;
			int stackSize = 1;
			class_2487 tagCompound = null;

			if (jsonObject.has(NAME) && jsonObject.get(NAME).isJsonPrimitive()) {
				name = jsonObject.getAsJsonPrimitive(NAME).getAsString();
			}

			if (jsonObject.has(STACK_SIZE) && jsonObject.get(STACK_SIZE).isJsonPrimitive()) {
				stackSize = jsonObject.getAsJsonPrimitive(STACK_SIZE).getAsInt();
			}

			if (jsonObject.has(TAG_COMPOUND) && jsonObject.get(TAG_COMPOUND).isJsonPrimitive()) {
				try {
					tagCompound = class_2522.method_10718(jsonObject.getAsJsonPrimitive(TAG_COMPOUND).getAsString());
				} catch (CommandSyntaxException e) {

				}
			}

			if (name != null && class_2378.field_11142.method_10223(new class_2960(name)) != null) {
				class_1799 itemStack = new class_1799(class_2378.field_11142.method_10223(new class_2960(name)), stackSize);
				itemStack.method_7980(tagCompound);
				return itemStack;
			}
		}

		return class_1799.field_8037;
	}

	@Override
	public JsonElement serialize(class_1799 src, Type typeOfSrc, JsonSerializationContext context) {

		if (src != null && src.method_7909() != null) {
			JsonObject jsonObject = new JsonObject();

			if (class_2378.field_11142.method_10221(src.method_7909()) != null) {
				jsonObject.addProperty(NAME, class_2378.field_11142.method_10221(src.method_7909()).toString());
			} else {
				return JsonNull.INSTANCE;
			}

			jsonObject.addProperty(STACK_SIZE, src.method_7947());

			if (src.method_7969() != null) {
				jsonObject.addProperty(TAG_COMPOUND, src.method_7969().toString());
			}

			return jsonObject;
		}

		return JsonNull.INSTANCE;
	}
}
