/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3419;
import reborncore.api.IToolDrop;
import reborncore.api.ToolManager;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.misc.ModSounds;

/**
 * @author drcrazy
 */
public class WrenchUtils {

	public static boolean handleWrench(class_1799 stack, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_2350 side) {
		class_2586 blockEntity = worldIn.method_8321(pos);
		if (blockEntity == null) {
			return false;
		}

		if (ToolManager.INSTANCE.handleTool(stack, pos, worldIn, playerIn, side, true)) {
			if (playerIn.method_5715()) {
				if (blockEntity instanceof IToolDrop) {
					class_1799 drop = ((IToolDrop) blockEntity).getToolDrop(playerIn);
					if (drop == null) {
						return false;
					}

					boolean dropContents = true;
					class_2248 block = blockEntity.method_11010().method_26204();
					if (block instanceof BaseBlockEntityProvider) {
						class_1799 blockEntityDrop = ((BaseBlockEntityProvider) block).getDropWithContents(worldIn, pos, drop).orElse(class_1799.field_8037);
						if (!blockEntityDrop.method_7960()) {
							dropContents = false;
							drop = blockEntityDrop;
						}
					}

					if (!worldIn.field_9236) {
						if (dropContents) {
							ItemHandlerUtils.dropContainedItems(worldIn, pos);
						}
						if (!drop.method_7960()) {
							net.minecraft.class_1264.method_5449(worldIn, pos.method_10263(), pos.method_10264(), pos.method_10260(), drop);
						}
						worldIn.method_8544(pos);
						worldIn.method_8652(pos, class_2246.field_10124.method_9564(), 2);
					}
					worldIn.method_8465(null, playerIn.method_23317(), playerIn.method_23318(), playerIn.method_23321(), ModSounds.BLOCK_DISMANTLE,
							class_3419.field_15245, 0.6F, 1F);
				}
			} else {
				class_2680 oldState = worldIn.method_8320(pos);
				class_2680 newState;
				if (oldState.method_28498(class_2741.field_12525)) {
					// Machine can face all 6 directions. Let's move face to hit side.
					newState = oldState.method_11657(class_2741.field_12525, side);
				} else {
					newState = oldState.method_26186(class_2470.field_11463);
				}

				if (!newState.method_26184(worldIn, pos)) {
					return false;
				}
				worldIn.method_8501(pos, newState);
				worldIn.method_8492(pos, newState.method_26204(), pos);
			}
			return true;
		}
		return false;
	}
}
