/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import reborncore.api.items.InventoryBase;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class RebornInventory<T extends MachineBaseBlockEntity> extends InventoryBase {

	private final String name;
	private final int stackLimit;
	private final T blockEntity;
	private boolean hasChanged = false;
	private final IInventoryAccess<T> inventoryAccess;

	public RebornInventory(int size, String invName, int invStackLimit, T blockEntity, IInventoryAccess<T> access) {
		super(size);
		name = invName;
		stackLimit = (invStackLimit == 64 ? class_1802.field_8162.method_7882() : invStackLimit); //Blame asie for this
		this.blockEntity = blockEntity;
		this.inventoryAccess = access;
	}

	//If you are using this with a machine, dont forget to set .withConfiguredAccess()
	public RebornInventory(int size, String invName, int invStackLimit, T blockEntity) {
		this(size, invName, invStackLimit, blockEntity, (slotID, stack, facing, direction, be) -> {
			if (facing == null) {
				return true;
			}
			switch (direction) {
				case INSERT:
					return SlotConfiguration.canInsertItem(slotID, stack, facing, be);
				case EXTRACT:
					return SlotConfiguration.canExtractItem(slotID, stack, facing, be);
			}
			return false;
		});
	}

	public String getName() {
		return name;
	}

	@Override
	public void method_5447(int slot, @NotNull class_1799 stack) {
		super.method_5447(slot, stack);
		setChanged();
	}

	@Override
	public class_1799 method_5434(int i, int i1) {
		class_1799 stack = super.method_5434(i, i1);

		if (!stack.method_7960()) {
			setChanged();
		}

		return stack;
	}

	@Override
	public int method_5444() {
		return stackLimit;
	}

	public class_1799 shrinkSlot(int slot, int count) {
		class_1799 stack = method_5438(slot);
		stack.method_7934(count);
		setChanged();
		return stack;
	}


	public RebornInventory getExternal(class_2350 facing) {
		throw new UnsupportedOperationException("needs fixing");
		//return externalInventory.withFacing(facing);
	}

	public void read(class_2487 data) {
		read(data, "Items");
	}

	public void read(class_2487 data, String tag) {
		class_2487 nbttaglist = data.method_10562(tag);
		deserializeNBT(nbttaglist);
		hasChanged = true;
	}

	public void write(class_2487 data) {
		write(data, "Items");
	}

	public void write(class_2487 data, String tag) {
		data.method_10566(tag, serializeNBT());
	}


	public int getContents() {
		int count = 0;
		for (class_1799 stack : getStacks()) {
			if (stack.method_7960()) {
				continue;
			}
			count += stack.method_7947();
		}
		return count;
	}

	public T getBlockEntity() {
		return blockEntity;
	}

	public boolean hasChanged() {
		return hasChanged;
	}

	public void setChanged() {
		this.hasChanged = true;
	}

	public void setChanged(boolean changed) {
		this.hasChanged = changed;
	}

	public void resetChanged() {
		this.hasChanged = false;
	}

	public int getStackLimit() {
		return stackLimit;
	}

	@Override
	public void method_5431() {
		super.method_5431();
		blockEntity.method_5431();
	}

}
