/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import reborncore.api.blockentity.IUpgradeable;

public class ItemHandlerUtils {

	public static void dropContainedItems(class_1937 world, class_2338 pos) {
		class_2586 blockEntity = world.method_8321(pos);
		if (blockEntity == null) {
			return;
		}
		if (blockEntity instanceof class_1263) {
			class_1263 inventory = (class_1263) blockEntity;
			dropItemHandler(world, pos, inventory);
		}
		if (blockEntity instanceof IUpgradeable) {
			dropItemHandler(world, pos, ((IUpgradeable) blockEntity).getUpgradeInvetory());
		}
	}

	public static void dropItemHandler(class_1937 world, class_2338 pos, class_1263 inventory) {
		for (int i = 0; i < inventory.method_5439(); i++) {
			class_1799 itemStack = inventory.method_5438(i);
			if (itemStack.method_7960()) {
				continue;
			}
			if (itemStack.method_7947() > 0) {
				if (itemStack.method_7909() instanceof class_1747) {
					if (((class_1747) itemStack.method_7909()).method_7711() instanceof class_2404) {
						continue;
					}
				}
			}
			class_1264.method_5449(world, pos.method_10263(), pos.method_10264(),
					pos.method_10260(), itemStack);
		}
	}
}
