/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import reborncore.RebornCore;
import reborncore.client.ClientChunkManager;
import reborncore.client.screen.builder.ExtendedScreenHandlerListener;
import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.chunkloading.ChunkLoaderManager;

import java.util.List;

@Environment(EnvType.CLIENT)
public class ClientBoundPacketHandlers {

	public static void init() {
		NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "custom_description"), (client, handler, packetBuffer, responseSender) -> {
			class_2338 pos = packetBuffer.method_10811();
			class_2487 tagCompound = packetBuffer.method_10798();
			client.execute(() -> {
				class_1937 world = class_310.method_1551().field_1687;
				if (world.method_22340(pos)) {
					class_2586 blockentity = world.method_8321(pos);
					if (blockentity != null && tagCompound != null) {
						blockentity.method_11014(blockentity.method_11010(), tagCompound);
					}
				}
			});
		});

		NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "fluid_config_sync"), (client, handler, packetBuffer, responseSender) -> {
			class_2338 pos = packetBuffer.method_10811();
			class_2487 compoundTag = packetBuffer.method_10798();

			client.execute(() -> {
				FluidConfiguration fluidConfiguration = new FluidConfiguration(compoundTag);
				if (!class_310.method_1551().field_1687.method_22340(pos)) {
					return;
				}
				MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity) class_310.method_1551().field_1687.method_8321(pos);
				if (machineBase == null || machineBase.fluidConfiguration == null || fluidConfiguration == null) {
					RebornCore.LOGGER.error("Failed to sync fluid config data to " + pos);
					return;
				}
				fluidConfiguration.getAllSides().forEach(fluidConfig -> machineBase.fluidConfiguration.updateFluidConfig(fluidConfig));
				machineBase.fluidConfiguration.setInput(fluidConfiguration.autoInput());
				machineBase.fluidConfiguration.setOutput(fluidConfiguration.autoOutput());

			});
		});

		NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "slot_sync"), (client, handler, packetBuffer, responseSender) -> {
			class_2338 pos = packetBuffer.method_10811();
			class_2487 compoundTag = packetBuffer.method_10798();

			client.execute(() -> {
				SlotConfiguration slotConfig = new SlotConfiguration(compoundTag);
				if (!class_310.method_1551().field_1687.method_22340(pos)) {
					return;
				}
				MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity) class_310.method_1551().field_1687.method_8321(pos);
				if (machineBase == null || machineBase.getSlotConfiguration() == null || slotConfig == null || slotConfig.getSlotDetails() == null) {
					RebornCore.LOGGER.error("Failed to sync slot data to " + pos);
					return;
				}
				class_310.method_1551().execute(() -> slotConfig.getSlotDetails().forEach(slotConfigHolder -> machineBase.getSlotConfiguration().updateSlotDetails(slotConfigHolder)));
			});
		});

		NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "send_object"), (client, handler, packetBuffer, responseSender) -> {
			int id = packetBuffer.readInt();
			Object value = new ExtendedPacketBuffer(packetBuffer).readObject();
			String container = packetBuffer.method_10800(packetBuffer.readInt());
			client.execute(() -> {
				class_437 gui = class_310.method_1551().field_1755;
				if (gui instanceof class_465) {
					class_1703 screenHandler = ((class_465) gui).method_17577();
					if (screenHandler instanceof ExtendedScreenHandlerListener) {
						((ExtendedScreenHandlerListener) screenHandler).handleObject(id, value);
					}
				}
			});
		});

		NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "sync_chunks"), (client, handler, packetBuffer, responseSender) -> {
			List<ChunkLoaderManager.LoadedChunk> chunks = new ExtendedPacketBuffer(packetBuffer).readCodec(ChunkLoaderManager.CODEC);

			client.execute(() -> ClientChunkManager.setLoadedChunks(chunks));
		});
	}

}
