/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.explosion;

import org.apache.commons.lang3.time.StopWatch;
import reborncore.RebornCore;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

/**
 * Created by modmuss50 on 12/03/2016.
 */
public class RebornExplosion extends class_1927 {

	@NotNull
	class_2338 center;

	@NotNull
	class_1937 world;

	@NotNull
	int radius;

	@Nullable
	class_1309 livingBase;

	public RebornExplosion(
		@NotNull
			class_2338 center,
		@NotNull
			class_1937 world,
		@NotNull
			int radius) {
		super(world, null, null, null, center.method_10263(), center.method_10264(), center.method_10260(), radius, false, class_4179.field_18687);
		this.center = center;
		this.world = world;
		this.radius = radius;
	}

	public void setLivingBase(
		@Nullable
			class_1309 livingBase) {
		this.livingBase = livingBase;
	}

	public
	@Nullable
	class_1309 getLivingBase() {
		return livingBase;
	}

	public void explode() {
		StopWatch watch = new StopWatch();
		watch.start();
		for (int tx = -radius; tx < radius + 1; tx++) {
			for (int ty = -radius; ty < radius + 1; ty++) {
				for (int tz = -radius; tz < radius + 1; tz++) {
					if (Math.sqrt(Math.pow(tx, 2) + Math.pow(ty, 2) + Math.pow(tz, 2)) <= radius - 2) {
						class_2338 pos = center.method_10069(tx, ty, tz);
						class_2680 state = world.method_8320(pos);
						class_2248 block = state.method_26204();
						if (block != class_2246.field_9987 && !state.method_26215()) {
							block.method_9586(world, pos, this);
							world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
						}
					}
				}
			}
		}
		RebornCore.LOGGER.info("The explosion took" + watch + " to explode");
	}

	@Override
	public void method_8348() {
		explode();
	}

	@Override
	public void method_8350(boolean spawnParticles) {
		explode();
	}

	@Override
	public
	@Nullable
	class_1309 method_8347() {
		return livingBase;
	}

	@Override
	public List<class_2338> method_8346() {
		List<class_2338> poses = new ArrayList<>();
		for (int tx = -radius; tx < radius + 1; tx++) {
			for (int ty = -radius; ty < radius + 1; ty++) {
				for (int tz = -radius; tz < radius + 1; tz++) {
					if (Math.sqrt(Math.pow(tx, 2) + Math.pow(ty, 2) + Math.pow(tz, 2)) <= radius - 2) {
						class_2338 pos = center.method_10069(tx, ty, tz);
						class_2680 state = world.method_8320(pos);
						class_2248 block = state.method_26204();
						if (block != class_2246.field_9987 && !state.method_26215()) {
							poses.add(pos);
						}
					}
				}
			}
		}
		return poses;
	}
}
