/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting;

import com.google.gson.JsonObject;
import reborncore.RebornCore;
import reborncore.common.util.serialization.SerializationUtil;

import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;

public class RebornRecipeType<R extends RebornRecipe> implements class_3956, class_1865 {

	private final BiFunction<RebornRecipeType<R>, class_2960, R> recipeFunction;

	private final class_2960 typeId;

	public RebornRecipeType(BiFunction<RebornRecipeType<R>, class_2960, R> recipeFunction, class_2960 typeId) {
		this.recipeFunction = recipeFunction;
		this.typeId = typeId;
	}

	@Override
	public R method_8121(class_2960 recipeId, JsonObject json) {
		class_2960 type = new class_2960(class_3518.method_15265(json, "type"));
		if (!type.equals(typeId)) {
			throw new RuntimeException("RebornRecipe type not supported!");
		}

		R recipe = newRecipe(recipeId);

		try{
			if(!ConditionManager.shouldLoadRecipe(json)) {
				recipe.makeDummy();
				return recipe;
			}

			recipe.deserialize(json);
		} catch (Throwable t){
			t.printStackTrace();
			RebornCore.LOGGER.error("Failed to read recipe: " + recipeId);
		}
		return recipe;

	}

	public JsonObject toJson(R recipe) {
		JsonObject jsonObject = new JsonObject();
		jsonObject.addProperty("type", typeId.toString());

		recipe.serialize(jsonObject);

		return jsonObject;
	}

	public R fromJson(class_2960 recipeType, JsonObject json) {
		return method_8121(recipeType, json);
	}

	R newRecipe(class_2960 recipeId) {
		return recipeFunction.apply(this, recipeId);
	}

	@Override
	public R method_8122(class_2960 recipeId, class_2540 buffer) {
		String input = buffer.method_10800(buffer.readInt());
		R r = method_8121(recipeId, SerializationUtil.GSON_FLAT.fromJson(input, JsonObject.class));
		r.deserialize(buffer);
		return r;
	}

	@Override
	public void method_8124(class_2540 buffer, class_1860 recipe) {
		JsonObject jsonObject = toJson((R) recipe);
		String output = SerializationUtil.GSON_FLAT.toJson(jsonObject);
		buffer.writeInt(output.length());
		buffer.method_10814(output);
		((R) recipe).serialize(buffer);
	}

	public class_2960 getName() {
		return typeId;
	}

	public List<R> getRecipes(class_1937 world) {
		return RecipeUtils.getRecipes(world, this);
	}

}
