/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.blockentity;

import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import reborncore.api.IListInfoProvider;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.fluid.FluidValue;
import reborncore.common.network.ClientBoundPackets;
import reborncore.common.network.NetworkManager;
import reborncore.common.recipes.IUpgradeHandler;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * Created by modmuss50 on 04/11/2016.
 */
public class MachineBaseBlockEntity extends class_2586 implements class_3000, IUpgradeable, IUpgradeHandler, IListInfoProvider, class_1263, class_1278 {

	public RebornInventory<MachineBaseBlockEntity> upgradeInventory = new RebornInventory<>(getUpgradeSlotCount(), "upgrades", 1, this, (slotID, stack, face, direction, blockEntity) -> true);
	private SlotConfiguration slotConfiguration;
	public FluidConfiguration fluidConfiguration;
	private RedstoneConfiguration redstoneConfiguration;

	public boolean renderMultiblock = false;

	private int ticktime = 0;

	/**
	 * This is used to change the speed of the crafting operation.
	 * <p/>
	 * 0 = none; 0.2 = 20% speed increase 0.75 = 75% increase
	 */
	double speedMultiplier = 0;
	/**
	 * This is used to change the power of the crafting operation.
	 * <p/>
	 * 1 = none; 1.2 = 20% speed increase 1.75 = 75% increase 5 = uses 5 times
	 * more power
	 */
	double powerMultiplier = 1;

	public MachineBaseBlockEntity(class_2591<?> blockEntityTypeIn) {
		super(blockEntityTypeIn);
		redstoneConfiguration = new RedstoneConfiguration(this);
	}

	public boolean isMultiblockValid() {
		MultiblockWriter.MultiblockVerifier verifier = new MultiblockWriter.MultiblockVerifier(method_11016(), method_10997());
		writeMultiblock(verifier.rotate(getFacing().method_10153()));
		return verifier.isValid();
	}

	public void writeMultiblock(MultiblockWriter writer) {}

	public void syncWithAll() {
		if (field_11863 == null || field_11863.field_9236) { return; }
		NetworkManager.sendToTracking(ClientBoundPackets.createCustomDescriptionPacket(this), this);
	}

	public void onLoad() {
		if (slotConfiguration == null) {
			if (getOptionalInventory().isPresent()) {
				slotConfiguration = new SlotConfiguration(getOptionalInventory().get());
			}
		}
		if (getTank() != null) {
			if (fluidConfiguration == null) {
				fluidConfiguration = new FluidConfiguration();
			}
		}
		redstoneConfiguration.refreshCache();
	}

	@Nullable
	@Override
	public class_2622 method_16886() {
		return new class_2622(method_11016(), 0, method_16887());
	}

	@Override
	public class_2487 method_16887() {
		class_2487 compound = super.method_11007(new class_2487());
		method_11007(compound);
		return compound;
	}

	@Override
	public void method_16896() {
		if (ticktime == 0) {
			onLoad();
		}
		ticktime++;
		@Nullable
		RecipeCrafter crafter = null;
		if (getOptionalCrafter().isPresent()) {
			crafter = getOptionalCrafter().get();
		}
		if (canBeUpgraded()) {
			resetUpgrades();
			for (int i = 0; i < getUpgradeSlotCount(); i++) {
				class_1799 stack = getUpgradeInvetory().method_5438(i);
				if (!stack.method_7960() && stack.method_7909() instanceof IUpgrade) {
					((IUpgrade) stack.method_7909()).process(this, this, stack);
				}
			}
		}
		if (field_11863 == null || field_11863.field_9236) {
			return;
		}
		if (crafter != null && isActive(RedstoneConfiguration.RECIPE_PROCESSING)) {
			crafter.updateEntity();
		}
		if (slotConfiguration != null && isActive(RedstoneConfiguration.ITEM_IO)) {
			slotConfiguration.update(this);
		}
		if (fluidConfiguration != null && isActive(RedstoneConfiguration.FLUID_IO)) {
			fluidConfiguration.update(this);
		}
	}

	public void resetUpgrades() {
		resetPowerMulti();
		resetSpeedMulti();
	}

	public int getFacingInt() {
		class_2248 block = field_11863.method_8320(field_11867).method_26204();
		if (block instanceof BlockMachineBase) {
			return ((BlockMachineBase) block).getFacing(field_11863.method_8320(field_11867)).method_10146();
		}
		return 0;
	}

	public class_2350 getFacingEnum() {
		class_2248 block = field_11863.method_8320(field_11867).method_26204();
		if (block instanceof BlockMachineBase) {
			return ((BlockMachineBase) block).getFacing(field_11863.method_8320(field_11867));
		}
		return class_2350.field_11043;
	}

	public void setFacing(class_2350 enumFacing) {
		class_2248 block = field_11863.method_8320(field_11867).method_26204();
		if (block instanceof BlockMachineBase) {
			((BlockMachineBase) block).setFacing(enumFacing, field_11863, field_11867);
		}
	}

	public boolean isActive() {
		class_2248 block = field_11863.method_8320(field_11867).method_26204();
		if (block instanceof BlockMachineBase) {
			return field_11863.method_8320(field_11867).method_11654(BlockMachineBase.ACTIVE);
		}
		return false;
	}

	public Optional<RebornInventory<?>> getOptionalInventory() {
		if (this instanceof InventoryProvider) {
			InventoryProvider inventory = (InventoryProvider) this;
			if (inventory.getInventory() == null) {
				return Optional.empty();
			}
			return Optional.of((RebornInventory<?>) inventory.getInventory());
		}
		return Optional.empty();
	}

	protected Optional<RecipeCrafter> getOptionalCrafter() {
		if (this instanceof IRecipeCrafterProvider) {
			IRecipeCrafterProvider crafterProvider = (IRecipeCrafterProvider) this;
			if (crafterProvider.getRecipeCrafter() == null) {
				return Optional.empty();
			}
			return Optional.of(crafterProvider.getRecipeCrafter());
		}
		return Optional.empty();
	}

	@Override
	public void method_11014(class_2680 blockState, class_2487 tagCompound) {
		super.method_11014(blockState, tagCompound);
		if (getOptionalInventory().isPresent()) {
			getOptionalInventory().get().read(tagCompound);
		}
		if (getOptionalCrafter().isPresent()) {
			getOptionalCrafter().get().read(tagCompound);
		}
		if (tagCompound.method_10545("slotConfig")) {
			slotConfiguration = new SlotConfiguration(tagCompound.method_10562("slotConfig"));
		} else {
			if (getOptionalInventory().isPresent()) {
				slotConfiguration = new SlotConfiguration(getOptionalInventory().get());
			}
		}
		if (tagCompound.method_10545("fluidConfig")) {
			fluidConfiguration = new FluidConfiguration(tagCompound.method_10562("fluidConfig"));
		}
		if (tagCompound.method_10545("redstoneConfig")) {
			redstoneConfiguration.refreshCache();
			redstoneConfiguration.read(tagCompound.method_10562("redstoneConfig"));
		}
		upgradeInventory.read(tagCompound, "Upgrades");
	}

	@Override
	public class_2487 method_11007(class_2487 tagCompound) {
		super.method_11007(tagCompound);
		if (getOptionalInventory().isPresent()) {
			getOptionalInventory().get().write(tagCompound);
		}
		if (getOptionalCrafter().isPresent()) {
			getOptionalCrafter().get().write(tagCompound);
		}
		if (slotConfiguration != null) {
			tagCompound.method_10566("slotConfig", slotConfiguration.write());
		}
		if (fluidConfiguration != null) {
			tagCompound.method_10566("fluidConfig", fluidConfiguration.write());
		}
		upgradeInventory.write(tagCompound, "Upgrades");
		tagCompound.method_10566("redstoneConfig", redstoneConfiguration.write());
		return tagCompound;
	}

	private boolean isItemValidForSlot(int index, class_1799 stack) {
		if (slotConfiguration == null) {
			return false;
		}
		SlotConfiguration.SlotConfigHolder slotConfigHolder = slotConfiguration.getSlotDetails(index);
		if (slotConfigHolder.filter() && getOptionalCrafter().isPresent()) {
			RecipeCrafter crafter = getOptionalCrafter().get();
			if (!crafter.isStackValidInput(stack)) {
				return false;
			}
		}
		return true;
	}
	//Inventory end

	@Override
	public class_1263 getUpgradeInvetory() {
		return upgradeInventory;
	}

	@Override
	public int getUpgradeSlotCount() {
		return 4;
	}

	public class_2350 getFacing() {
		return getFacingEnum();
	}

	@Override
	public void method_11013(class_2470 rotationIn) {
		setFacing(rotationIn.method_10503(getFacing()));
	}

	@Override
	public void resetSpeedMulti() {
		speedMultiplier = 0;
	}

	@Override
	public double getSpeedMultiplier() {
		return speedMultiplier;
	}

	@Override
	public void addPowerMulti(double amount) {
		powerMultiplier = powerMultiplier * (1f + amount);
	}

	@Override
	public void resetPowerMulti() {
		powerMultiplier = 1;
	}

	@Override
	public double getPowerMultiplier() {
		return powerMultiplier;
	}

	@Override
	public double getEuPerTick(double baseEu) {
		return baseEu * powerMultiplier;
	}

	@Override
	public void addSpeedMulti(double amount) {
		if (speedMultiplier + amount <= 0.99) {
			speedMultiplier += amount;
		} else {
			speedMultiplier = 0.99;
		}
	}

	public boolean hasSlotConfig() {
		return true;
	}

	@Nullable
	public Tank getTank() {
		return null;
	}

	public boolean showTankConfig() {
		return getTank() != null;
	}

	//The amount of ticks between a slot tranfer atempt, less is faster
	public int slotTransferSpeed() {
		return 4;
	}

	//The amount of fluid transfured each tick buy the fluid config
	public FluidValue fluidTransferAmount() {
		return FluidValue.BUCKET_QUARTER;
	}

	@Override
	public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
		if (hasData) {
			if (getOptionalInventory().isPresent()) {
				info.add(new class_2585(class_124.field_1065 + "" + getOptionalInventory().get().getContents() + class_124.field_1080 + " items"));
			}
			if (!upgradeInventory.method_5442()) {
				info.add(new class_2585(class_124 .field_1065 + "" + upgradeInventory.getContents() + class_124 .field_1080 + " upgrades"));
			}
		}
	}

	public class_2248 getBlockType(){
		return field_11863.method_8320(field_11867).method_26204();
	}

	@Override
	public int method_5439() {
		if(getOptionalInventory().isPresent()){
			return getOptionalInventory().get().method_5439();
		}
		return 0;
	}

	@Override
	public boolean method_5442() {
		if(getOptionalInventory().isPresent()){
			return getOptionalInventory().get().method_5442();
		}
		return true;
	}

	@Override
	public class_1799 method_5438(int i) {
		if(getOptionalInventory().isPresent()){
			return getOptionalInventory().get().method_5438(i);
		}
		return class_1799.field_8037;
	}

	@Override
	public class_1799 method_5434(int i, int i1) {
		if(getOptionalInventory().isPresent()){
			return getOptionalInventory().get().method_5434(i, i1);
		}
		return class_1799.field_8037;
	}

	@Override
	public class_1799 method_5441(int i) {
		if(getOptionalInventory().isPresent()){
			return getOptionalInventory().get().method_5441(i);
		}
		return class_1799.field_8037;
	}

	@Override
	public void method_5447(int i, class_1799 itemStack) {
		if(getOptionalInventory().isPresent()){
			getOptionalInventory().get().method_5447(i, itemStack);
		}
	}

	@Override
	public boolean method_5443(class_1657 playerEntity) {
		if(getOptionalInventory().isPresent()){
			return getOptionalInventory().get().method_5443(playerEntity);
		}
		return false;
	}
	
	@Override
	public boolean method_5437(int slot, class_1799 stack) {
		return isItemValidForSlot(slot, stack);
	}

	@Override
	public void method_5448() {
		if(getOptionalInventory().isPresent()){
			getOptionalInventory().get().method_5448();
		}
	}

	@NotNull
	public SlotConfiguration getSlotConfiguration() {
		Validate.notNull(slotConfiguration, "slotConfiguration cannot be null");
		return slotConfiguration;
	}

	@Override
	public int[] method_5494(class_2350 side) {
		if(slotConfiguration == null){
			return new int[]{}; //I think should be ok, if needed this can return all the slots
		}
		return slotConfiguration.getSlotsForSide(side).stream()
			.filter(Objects::nonNull)
			.filter(slotConfig -> slotConfig.getSlotIO().ioConfig != SlotConfiguration.ExtractConfig.NONE)
			.mapToInt(SlotConfiguration.SlotConfig::getSlotID).toArray();
	}

	@Override
	public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
		if(direction == null || slotConfiguration == null){
			return false;
		}
		SlotConfiguration.SlotConfigHolder slotConfigHolder = slotConfiguration.getSlotDetails(index);
		SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
		if (slotConfig.getSlotIO().ioConfig.isInsert()) {
			if (slotConfigHolder.filter() && getOptionalCrafter().isPresent()) {
				RecipeCrafter crafter = getOptionalCrafter().get();
				return crafter.isStackValidInput(stack);
			}
			return slotConfig.getSlotIO().getIoConfig().isInsert();
		}
		return false;
	}

	@Override
	public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
		if (slotConfiguration == null) {
			return false;
		}
		SlotConfiguration.SlotConfigHolder slotConfigHolder = slotConfiguration.getSlotDetails(index);
		SlotConfiguration.SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
		return slotConfig.getSlotIO().ioConfig.isExtact();
	}

	public void onBreak(class_1937 world, class_1657 playerEntity, class_2338 blockPos, class_2680 blockState){

	}

	public void onPlace(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack){

	}

	public RedstoneConfiguration getRedstoneConfiguration() {
		return redstoneConfiguration;
	}

	public boolean isActive(RedstoneConfiguration.Element element) {
		return redstoneConfiguration.isActive(element);
	}
}