/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui.slots;

import reborncore.mixin.common.AccessorSlot;

import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

/**
 * Created by modmuss50 on 11/04/2016.
 */
public class BaseSlot extends class_1735 {

	private Predicate<class_1799> filter = (stack) -> true;

	public BaseSlot(class_1263 inventoryIn, int index, int xPosition, int yPosition) {
		super(inventoryIn, index, xPosition, yPosition);
	}

	public BaseSlot(class_1263 inventoryIn, int index, int xPosition, int yPosition, Predicate<class_1799> filter) {
		super(inventoryIn, index, xPosition, yPosition);
		this.filter = filter;
	}

	public boolean canWorldBlockRemove() {
		return true;
	}

	@Override
	public boolean method_7680(class_1799 stack) {
		return filter.test(stack);
	}

	public boolean canWorldBlockInsert() {
		return true;
	}

	public int getSlotID() {
		return ((AccessorSlot) this).getIndex();
	}
}
