/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui;

import net.minecraft.class_1060;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL11;
import reborncore.common.util.Color;

public class GuiButtonCustomTexture extends class_4185 {
	public int textureU;
	public int textureV;
	public String texturename;
	public String linkedPage;
	public class_2561 name;
	public String imageprefix = "techreborn:textures/manual/elements/";
	public int buttonHeight;
	public int buttonWidth;
	public int buttonU;
	public int buttonV;
	public int textureH;
	public int textureW;

	public GuiButtonCustomTexture(int xPos, int yPos, int u, int v, int buttonWidth, int buttonHeight,
								  String texturename, String linkedPage, class_2561 name, int buttonU, int buttonV, int textureH, int textureW, class_4185.class_4241 pressAction) {
		super(xPos, yPos, buttonWidth, buttonHeight, class_2585.field_24366, pressAction);
		this.textureU = u;
		this.textureV = v;
		this.texturename = texturename;
		this.name = name;
		this.linkedPage = linkedPage;
		this.buttonHeight = field_22759;
		this.buttonWidth = field_22758;
		this.buttonU = buttonU;
		this.buttonV = buttonV;
		this.textureH = textureH;
		this.textureW = textureW;
	}

	public void drawButton(class_4587 matrixStack, class_310 mc, int mouseX, int mouseY) {
		if (this.field_22764) {
			boolean flag = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758
					&& mouseY < this.field_22761 + this.field_22759;
			mc.method_1531().method_22813(field_22757);
			int u = textureU;
			int v = textureV;

			if (flag) {
				u += field_22758;
				GL11.glPushMatrix();
				GL11.glColor4f(0f, 0f, 0f, 1f);
				this.method_25302(matrixStack, this.field_22760, this.field_22761, u, v, field_22758, field_22759);
				GL11.glPopMatrix();
			}
			GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
			GL11.glEnable(32826);
			class_308.method_22890();
			renderImage(matrixStack, this.field_22760, this.field_22761);
			this.method_27535(matrixStack, mc.field_1772, this.name, this.field_22760 + 20, this.field_22761 + 3,
					Color.WHITE.getColor());
		}
	}

	public void renderImage(class_4587 matrixStack, int offsetX, int offsetY) {
		class_1060 render = class_310.method_1551().method_1531();
		render.method_22813(new class_2960(imageprefix + this.texturename + ".png"));

		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		GL11.glColor4f(1F, 1F, 1F, 1F);
		method_25302(matrixStack, offsetX, offsetY, this.buttonU, this.buttonV, this.textureW, this.textureH);
		GL11.glDisable(GL11.GL_BLEND);
	}

}
