/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import net.minecraft.class_918;
import org.apache.commons.io.FileUtils;
import org.lwjgl.opengl.GL11;

import java.io.File;

/**
 * Initially take from https://github.com/JamiesWhiteShirt/developer-mode/tree/experimental-item-render and then ported to 1.15
 * Thanks 2xsaiko for fixing the lighting + odd issues above
 */
public class ItemStackRenderer implements HudRenderCallback {

	@Override
	public void onHudRender(class_4587 matrixStack, float v) {
		if (!ItemStackRenderManager.RENDER_QUEUE.isEmpty()) {

			class_310.method_1551().field_1772.method_1729(matrixStack, "Rendering " + ItemStackRenderManager.RENDER_QUEUE.size() + " items left", 5, 5, -1);

			class_1799 itemStack = ItemStackRenderManager.RENDER_QUEUE.poll();
			export(itemStack, 512, class_2378.field_11142.method_10221(itemStack.method_7909()));
		}
	}

	private void export(class_1799 stack, int size, class_2960 identifier) {
		File dir = new File(FabricLoader.getInstance().getGameDirectory(), "item_renderer/" + identifier.method_12836());
		if (!dir.exists()) {
			dir.mkdir();
		}
		File file = new File(dir, identifier.method_12832() + ".png");

		if (file.exists()) {
			file.delete();
		}

		class_310 minecraft = class_310.method_1551();

		if (minecraft.method_1480() == null || minecraft.field_1687 == null) {
			return;
		}

		final class_276 framebuffer = new class_276(size, size, true, class_310.field_1703);
		framebuffer.method_1236(0.0F, 0.0F, 0.0F, 0.0F);
		framebuffer.method_1230(class_310.field_1703);

		framebuffer.method_1235(true);

		final class_918 itemRenderer = class_310.method_1551().method_1480();
		final class_1087 model = itemRenderer.method_4019(stack, minecraft.field_1687, minecraft.field_1724);

		RenderSystem.matrixMode(GL11.GL_PROJECTION);
		RenderSystem.pushMatrix();
		RenderSystem.loadIdentity();
		RenderSystem.ortho(-1, 1, 1, -1, -100.0, 100.0);
		RenderSystem.matrixMode(GL11.GL_MODELVIEW);
		RenderSystem.pushMatrix();
		RenderSystem.loadIdentity();

		{
			minecraft.method_1531().method_22813(class_1059.field_5275);
			minecraft.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);

			RenderSystem.enableRescaleNormal();
			RenderSystem.enableAlphaTest();
			RenderSystem.defaultAlphaFunc();
			RenderSystem.enableBlend();
			RenderSystem.enableDepthTest();
			RenderSystem.blendFunc(class_4493.class_4535.field_22541, class_4493.class_4534.field_22523);

			RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
			class_4587 matrixStack = new class_4587();

			matrixStack.method_22905(2F, -2F, 1F);

			boolean frontLit = !model.method_24304();
			if (frontLit) {
				class_308.method_24210();
			}

			class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
			itemRenderer.method_23179(stack, class_809.class_811.field_4317, false, matrixStack, immediate, 15728880, class_4608.field_21444, model);
			immediate.method_22993();

			RenderSystem.enableDepthTest();

			if (frontLit) {
				class_308.method_24211();
			}

			RenderSystem.disableAlphaTest();
			RenderSystem.disableRescaleNormal();
		}

		RenderSystem.popMatrix();
		RenderSystem.matrixMode(GL11.GL_PROJECTION);
		RenderSystem.popMatrix();
		RenderSystem.matrixMode(GL11.GL_MODELVIEW);

		framebuffer.method_1240();


		try (class_1011 nativeImage = new class_1011(size, size, false)) {
			class_4493.method_22081(framebuffer.method_30277());
			nativeImage.method_4327(0, false);
			nativeImage.method_4319();

			try {
				byte[] bytes = nativeImage.method_24036();
				FileUtils.writeByteArrayToFile(file, bytes);
				System.out.println("Wrote " + file.getAbsolutePath());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		framebuffer.method_1238();
	}
}
