/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import reborncore.RebornCore;

public class IconSupplier {

	public static class_2960 armour_head_id = new class_2960(RebornCore.MOD_ID, "gui/slot_sprites/armour_head");
	public static class_2960 armour_chest_id = new class_2960(RebornCore.MOD_ID, "gui/slot_sprites/armour_chest");
	public static class_2960 armour_legs_id = new class_2960(RebornCore.MOD_ID, "gui/slot_sprites/armour_legs");
	public static class_2960 armour_feet_id = new class_2960(RebornCore.MOD_ID, "gui/slot_sprites/armour_feet");

	@Environment(EnvType.CLIENT)
	public static void registerSprites(class_1059 atlasTexture, ClientSpriteRegistryCallback.Registry registry) {
		registry.register(IconSupplier.armour_head_id);
		registry.register(IconSupplier.armour_chest_id);
		registry.register(IconSupplier.armour_legs_id);
		registry.register(IconSupplier.armour_feet_id);
	}
}
