/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.client.screen.builder.Syncable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.fluid.container.GenericFluidContainer;

public class Tank
implements GenericFluidContainer<class_2350>,
Syncable {
    private final String name;
    @Nonnull
    private FluidInstance fluidInstance = new FluidInstance();
    private final FluidValue capacity;
    @Nullable
    private class_2350 side = null;
    private final MachineBaseBlockEntity blockEntity;

    public Tank(String name, FluidValue capacity, MachineBaseBlockEntity blockEntity) {
        this.name = name;
        this.capacity = capacity;
        this.blockEntity = blockEntity;
    }

    @Nonnull
    public FluidInstance getFluidInstance() {
        return this.getFluidInstance(this.side);
    }

    @Nonnull
    public class_3611 getFluid() {
        return this.getFluidInstance().getFluid();
    }

    public FluidValue getCapacity() {
        return this.capacity;
    }

    public FluidValue getFreeSpace() {
        return this.getCapacity().subtract(this.getFluidAmount());
    }

    public boolean canFit(class_3611 fluid, FluidValue amount) {
        return (this.isEmpty() || this.getFluid() == fluid) && this.getFreeSpace().equalOrMoreThan(amount);
    }

    public boolean isEmpty() {
        return this.getFluidInstance().isEmpty();
    }

    public boolean isFull() {
        return !this.getFluidInstance().isEmpty() && this.getFluidInstance().getAmount().equalOrMoreThan(this.getCapacity());
    }

    public final class_2487 write(class_2487 nbt) {
        class_2487 tankData = this.fluidInstance.write();
        nbt.method_10566(this.name, (class_2520)tankData);
        return nbt;
    }

    public void setFluidAmount(FluidValue amount) {
        if (!this.fluidInstance.isEmptyFluid()) {
            this.fluidInstance.setAmount(amount);
        }
    }

    public final Tank read(class_2487 nbt) {
        if (nbt.method_10545(this.name)) {
            this.setFluid(class_3612.field_15906);
            class_2487 tankData = nbt.method_10562(this.name);
            this.fluidInstance = new FluidInstance(tankData);
        }
        return this;
    }

    public void setFluid(@Nonnull class_3611 f) {
        Validate.notNull((Object)f);
        this.fluidInstance.setFluid(f);
    }

    @Nullable
    public class_2350 getSide() {
        return this.side;
    }

    public void setSide(@Nullable class_2350 side) {
        this.side = side;
    }

    @Override
    public void getSyncPair(List<Pair<Supplier, Consumer>> pairList) {
        pairList.add((Pair<Supplier, Consumer>)Pair.of(() -> class_2378.field_11154.method_10221((Object)this.fluidInstance.getFluid()).toString(), o -> this.fluidInstance.setFluid((class_3611)class_2378.field_11154.method_10223(new class_2960(o)))));
        pairList.add((Pair<Supplier, Consumer>)Pair.of(() -> this.fluidInstance.getAmount(), o -> this.fluidInstance.setAmount((FluidValue)o)));
    }

    public FluidValue getFluidAmount() {
        return this.getFluidInstance().getAmount();
    }

    @Override
    public void setFluid(@Nullable class_2350 type, @Nonnull FluidInstance instance) {
        this.fluidInstance = instance;
    }

    @Override
    @Nonnull
    public FluidInstance getFluidInstance(@Nullable class_2350 type) {
        return this.fluidInstance;
    }

    public void setFluidInstance(@Nonnull FluidInstance fluidInstance) {
        this.fluidInstance = fluidInstance;
    }

    @Override
    public FluidValue getCapacity(@Nullable class_2350 type) {
        return this.capacity;
    }
}

