/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2792;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.Validate;
import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.chunkloading.ChunkLoaderManager;
import reborncore.common.network.ClientBoundPackets;
import reborncore.common.network.NetworkManager;

public class ServerBoundPackets {
    public static void init() {
        NetworkManager.registerServerBoundHandler(new class_2960("reborncore", "fluid_config_save"), (packetBuffer, context) -> {
            class_2338 pos = packetBuffer.method_10811();
            class_2487 compoundTag = packetBuffer.method_10798();
            context.getTaskQueue().execute(() -> {
                FluidConfiguration.FluidConfig fluidConfiguration = new FluidConfiguration.FluidConfig(compoundTag);
                MachineBaseBlockEntity legacyMachineBase = (MachineBaseBlockEntity)context.getPlayer().field_6002.method_8321(pos);
                legacyMachineBase.fluidConfiguration.updateFluidConfig(fluidConfiguration);
                legacyMachineBase.method_5431();
                class_2596<class_2602> packetFluidConfigSync = ClientBoundPackets.createPacketFluidConfigSync(pos, legacyMachineBase.fluidConfiguration);
                NetworkManager.sendToTracking(packetFluidConfigSync, legacyMachineBase);
                class_1937 world = legacyMachineBase.method_10997();
                class_2680 blockState = world.method_8320(legacyMachineBase.method_11016());
                world.method_8452(legacyMachineBase.method_11016(), blockState.method_26204());
            });
        });
        NetworkManager.registerServerBoundHandler(new class_2960("reborncore", "config_save"), (packetBuffer, context) -> {
            class_2338 pos = packetBuffer.method_10811();
            class_2487 tagCompound = packetBuffer.method_10798();
            context.getTaskQueue().execute(() -> {
                MachineBaseBlockEntity legacyMachineBase = (MachineBaseBlockEntity)context.getPlayer().field_6002.method_8321(pos);
                legacyMachineBase.getSlotConfiguration().read(tagCompound);
                legacyMachineBase.method_5431();
                class_2596<class_2602> packetSlotSync = ClientBoundPackets.createPacketSlotSync(pos, legacyMachineBase.getSlotConfiguration());
                NetworkManager.sendToWorld(packetSlotSync, (class_3218)legacyMachineBase.method_10997());
            });
        });
        NetworkManager.registerServerBoundHandler(new class_2960("reborncore", "fluid_io_save"), (packetBuffer, context) -> {
            class_2338 pos = packetBuffer.method_10811();
            boolean input = packetBuffer.readBoolean();
            boolean output = packetBuffer.readBoolean();
            context.getTaskQueue().execute(() -> {
                MachineBaseBlockEntity legacyMachineBase = (MachineBaseBlockEntity)context.getPlayer().field_6002.method_8321(pos);
                FluidConfiguration config = legacyMachineBase.fluidConfiguration;
                if (config == null) {
                    return;
                }
                config.setInput(input);
                config.setOutput(output);
                class_2596<class_2602> packetFluidConfigSync = ClientBoundPackets.createPacketFluidConfigSync(pos, legacyMachineBase.fluidConfiguration);
                NetworkManager.sendToTracking(packetFluidConfigSync, legacyMachineBase);
            });
        });
        NetworkManager.registerServerBoundHandler(new class_2960("reborncore", "io_save"), (packetBuffer, context) -> {
            class_2338 pos = packetBuffer.method_10811();
            int slotID = packetBuffer.readInt();
            boolean input = packetBuffer.readBoolean();
            boolean output = packetBuffer.readBoolean();
            boolean filter = packetBuffer.readBoolean();
            context.getTaskQueue().execute(() -> {
                MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity)context.getPlayer().field_6002.method_8321(pos);
                Validate.notNull((Object)machineBase, (String)"machine cannot be null", (Object[])new Object[0]);
                SlotConfiguration.SlotConfigHolder holder = machineBase.getSlotConfiguration().getSlotDetails(slotID);
                if (holder == null) {
                    return;
                }
                holder.setInput(input);
                holder.setOutput(output);
                holder.setfilter(filter);
                class_2596<class_2602> packetSlotSync = ClientBoundPackets.createPacketSlotSync(pos, machineBase.getSlotConfiguration());
                NetworkManager.sendToAll(packetSlotSync, context.getPlayer().method_5682());
            });
        });
        NetworkManager.registerServerBoundHandler(new class_2960("reborncore", "slot_save"), (packetBuffer, context) -> {
            class_2338 pos = packetBuffer.method_10811();
            class_2487 compoundTag = packetBuffer.method_10798();
            context.getTaskQueue().execute(() -> {
                SlotConfiguration.SlotConfig slotConfig = new SlotConfiguration.SlotConfig(compoundTag);
                MachineBaseBlockEntity legacyMachineBase = (MachineBaseBlockEntity)context.getPlayer().field_6002.method_8321(pos);
                legacyMachineBase.getSlotConfiguration().getSlotDetails(slotConfig.getSlotID()).updateSlotConfig(slotConfig);
                legacyMachineBase.method_5431();
                class_2596<class_2602> packetSlotSync = ClientBoundPackets.createPacketSlotSync(pos, legacyMachineBase.getSlotConfiguration());
                NetworkManager.sendToWorld(packetSlotSync, (class_3218)legacyMachineBase.method_10997());
            });
        });
        NetworkManager.registerServerBoundHandler(new class_2960("reborncore", "chunk_loader_request"), (packetBuffer, context) -> {
            class_2338 pos = packetBuffer.method_10811();
            context.getTaskQueue().execute(() -> {
                Validate.isInstanceOf(class_3222.class, (Object)context.getPlayer(), (String)"something very very bad has happened", (Object[])new Object[0]);
                ChunkLoaderManager chunkLoaderManager = ChunkLoaderManager.get(context.getPlayer().field_6002);
                chunkLoaderManager.syncChunkLoaderToClient((class_3222)context.getPlayer(), pos);
            });
        });
        NetworkManager.registerServerBoundHandler(new class_2960("reborncore", "set_redstone_state"), (packetBuffer, context) -> {
            class_2338 pos = packetBuffer.method_10811();
            String elementName = packetBuffer.method_10800(packetBuffer.readInt());
            int stateId = packetBuffer.readInt();
            RedstoneConfiguration.Element element = RedstoneConfiguration.getElementByName(elementName);
            if (element == null) {
                return;
            }
            if (stateId < 0 || stateId >= RedstoneConfiguration.State.values().length) {
                return;
            }
            RedstoneConfiguration.State state = RedstoneConfiguration.State.values()[stateId];
            context.getTaskQueue().execute(() -> {
                MachineBaseBlockEntity blockEntity = (MachineBaseBlockEntity)context.getPlayer().field_6002.method_8321(pos);
                if (blockEntity == null) {
                    return;
                }
                blockEntity.getRedstoneConfiguration().setState(element, state);
            });
        });
    }

    public static class_2596<class_2792> createPacketFluidConfigSave(class_2338 pos, FluidConfiguration.FluidConfig fluidConfiguration) {
        return NetworkManager.createServerBoundPacket(new class_2960("reborncore", "fluid_config_save"), packetBuffer -> {
            packetBuffer.method_10807(pos);
            packetBuffer.method_10794(fluidConfiguration.write());
        });
    }

    public static class_2596<class_2792> createPacketConfigSave(class_2338 pos, SlotConfiguration slotConfig) {
        return NetworkManager.createServerBoundPacket(new class_2960("reborncore", "config_save"), packetBuffer -> {
            packetBuffer.method_10807(pos);
            packetBuffer.method_10794(slotConfig.write());
        });
    }

    public static class_2596<class_2792> createPacketFluidIOSave(class_2338 pos, boolean input, boolean output) {
        return NetworkManager.createServerBoundPacket(new class_2960("reborncore", "fluid_io_save"), packetBuffer -> {
            packetBuffer.method_10807(pos);
            packetBuffer.writeBoolean(input);
            packetBuffer.writeBoolean(output);
        });
    }

    public static class_2596<class_2792> createPacketIOSave(class_2338 pos, int slotID, boolean input, boolean output, boolean filter) {
        return NetworkManager.createServerBoundPacket(new class_2960("reborncore", "io_save"), packetBuffer -> {
            packetBuffer.method_10807(pos);
            packetBuffer.writeInt(slotID);
            packetBuffer.writeBoolean(input);
            packetBuffer.writeBoolean(output);
            packetBuffer.writeBoolean(filter);
        });
    }

    public static class_2596<class_2792> createPacketSlotSave(class_2338 pos, SlotConfiguration.SlotConfig slotConfig) {
        return NetworkManager.createServerBoundPacket(new class_2960("reborncore", "slot_save"), packetBuffer -> {
            packetBuffer.method_10807(pos);
            packetBuffer.method_10794(slotConfig.write());
        });
    }

    public static class_2596<class_2792> requestChunkloaderChunks(class_2338 pos) {
        return NetworkManager.createServerBoundPacket(new class_2960("reborncore", "chunk_loader_request"), packetBuffer -> packetBuffer.method_10807(pos));
    }

    public static class_2596<class_2792> createPacketSetRedstoneSate(class_2338 pos, RedstoneConfiguration.Element element, RedstoneConfiguration.State state) {
        return NetworkManager.createServerBoundPacket(new class_2960("reborncore", "set_redstone_state"), packetBuffer -> {
            packetBuffer.method_10807(pos);
            packetBuffer.writeInt(element.getName().length());
            packetBuffer.method_10814(element.getName());
            packetBuffer.writeInt(state.ordinal());
        });
    }
}

