/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import reborncore.common.fluid.FluidValue;
import reborncore.common.network.ExtendedPacketBuffer;

public enum ObjectBufferUtils {
    STRING(String.class, (string, buffer) -> {
        buffer.writeInt(string.length());
        buffer.method_10814((String)string);
    }, buffer -> buffer.method_10800(buffer.readInt())),
    INT(Integer.class, (value, buffer) -> buffer.writeInt((int)value), class_2540::readInt),
    LONG(Long.class, (pos, buffer) -> buffer.writeLong((long)pos), class_2540::readLong),
    DOUBLE(Double.class, (pos, buffer) -> buffer.writeDouble((double)pos), class_2540::readDouble),
    FLOAT(Float.class, (pos, buffer) -> buffer.writeFloat(pos.floatValue()), class_2540::readFloat),
    BLOCK_POS(class_2338.class, (pos, buffer) -> buffer.method_10807((class_2338)pos), class_2540::method_10811),
    ID(class_2960.class, (id, buffer) -> {
        String string = id.toString();
        buffer.writeInt(string.length());
        buffer.method_10814(string);
    }, buffer -> new class_2960(buffer.method_10800(buffer.readInt()))),
    FLUID_VALUE(FluidValue.class, (value, buffer) -> buffer.writeInt(value.getRawValue()), buffer -> FluidValue.fromRaw(buffer.readInt())),
    COMPOUND_TAG(class_2487.class, (value, buffer) -> buffer.method_10794((class_2487)value), class_2540::method_10798),
    BIG_INT(BigInteger.class, (pos, buffer) -> buffer.writeBigInt((BigInteger)pos), ExtendedPacketBuffer::readBigInt);

    Class clazz;
    ObjectWriter writer;
    ObjectReader reader;

    private <T> ObjectBufferUtils(Class<T> clazz, ObjectWriter<T> writer, ObjectReader<T> reader) {
        this.clazz = clazz;
        this.writer = writer;
        this.reader = reader;
    }

    public static void writeObject(Object object, ExtendedPacketBuffer buffer) {
        ObjectBufferUtils utils = Arrays.stream(ObjectBufferUtils.values()).filter(objectBufferUtils -> objectBufferUtils.clazz == object.getClass()).findFirst().orElse(null);
        Objects.requireNonNull(utils, "No support found for " + object.getClass());
        buffer.writeInt(utils.ordinal());
        utils.writer.write(object, buffer);
    }

    public static Object readObject(ExtendedPacketBuffer buffer) {
        ObjectBufferUtils utils = ObjectBufferUtils.values()[buffer.readInt()];
        Objects.requireNonNull(utils, "Could not find reader");
        return utils.reader.read(buffer);
    }

    private static interface ObjectReader<T> {
        public T read(ExtendedPacketBuffer var1);
    }

    private static interface ObjectWriter<T> {
        public void write(T var1, ExtendedPacketBuffer var2);
    }
}

