/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import reborncore.common.crafting.ingredient.FluidIngredient;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.crafting.ingredient.StackIngredient;
import reborncore.common.crafting.ingredient.TagIngredient;
import reborncore.common.crafting.ingredient.WrappedIngredient;

public class IngredientManager {
    public static final class_2960 STACK_RECIPE_TYPE = new class_2960("reborncore", "stack");
    public static final class_2960 FLUID_RECIPE_TYPE = new class_2960("reborncore", "fluid");
    public static final class_2960 TAG_RECIPE_TYPE = new class_2960("reborncore", "tag");
    public static final class_2960 WRAPPED_RECIPE_TYPE = new class_2960("reborncore", "wrapped");
    private static final HashMap<class_2960, Function<JsonObject, RebornIngredient>> recipeTypes = new HashMap();

    public static void setup() {
        recipeTypes.put(STACK_RECIPE_TYPE, StackIngredient::deserialize);
        recipeTypes.put(FLUID_RECIPE_TYPE, FluidIngredient::deserialize);
        recipeTypes.put(TAG_RECIPE_TYPE, TagIngredient::deserialize);
        recipeTypes.put(WRAPPED_RECIPE_TYPE, WrappedIngredient::deserialize);
    }

    public static RebornIngredient deserialize(@Nullable JsonElement jsonElement) {
        Function<JsonObject, RebornIngredient> recipeTypeFunction;
        if (jsonElement == null || !jsonElement.isJsonObject()) {
            throw new JsonParseException("ingredient must be a json object");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        class_2960 recipeTypeIdent = STACK_RECIPE_TYPE;
        if (json.has("fluid")) {
            recipeTypeIdent = FLUID_RECIPE_TYPE;
        } else if (json.has("tag")) {
            recipeTypeIdent = TAG_RECIPE_TYPE;
        } else if (json.has("wrapped")) {
            recipeTypeIdent = WRAPPED_RECIPE_TYPE;
        }
        if (json.has("type")) {
            recipeTypeIdent = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
        }
        if ((recipeTypeFunction = recipeTypes.get(recipeTypeIdent)) == null) {
            throw new JsonParseException("No recipe type found for " + recipeTypeIdent.toString());
        }
        return recipeTypeFunction.apply(json);
    }
}

