/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.chunkloading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import reborncore.common.network.ClientBoundPackets;

public class ChunkLoaderManager
extends class_18 {
    public static Codec<List<LoadedChunk>> CODEC = Codec.list(LoadedChunk.CODEC);
    private static final class_3230<class_1923> CHUNK_LOADER = class_3230.method_14291((String)"reborncore:chunk_loader", Comparator.comparingLong(class_1923::method_8324));
    private static final String KEY = "reborncore_chunk_loader";
    private final List<LoadedChunk> loadedChunks = new ArrayList<LoadedChunk>();

    public ChunkLoaderManager() {
        super(KEY);
    }

    public static ChunkLoaderManager get(class_1937 world) {
        class_3218 serverWorld = (class_3218)world;
        return (ChunkLoaderManager)serverWorld.method_17983().method_17924(ChunkLoaderManager::new, KEY);
    }

    public void method_77(class_2487 tag) {
        this.loadedChunks.clear();
        List chunks = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("loadedchunks")).result().orElse(Collections.emptyList());
        this.loadedChunks.addAll(chunks);
    }

    public class_2487 method_75(class_2487 compoundTag) {
        CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.loadedChunks).result().ifPresent(tag -> compoundTag.method_10566("loadedchunks", tag));
        return compoundTag;
    }

    public Optional<LoadedChunk> getLoadedChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.getWorld().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.getChunk().equals((Object)chunkPos)).filter(loadedChunk -> loadedChunk.getChunkLoader().equals((Object)chunkLoader)).findFirst();
    }

    public Optional<LoadedChunk> getLoadedChunk(class_1937 world, class_1923 chunkPos) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.getWorld().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.getChunk().equals((Object)chunkPos)).findFirst();
    }

    public List<LoadedChunk> getLoadedChunks(class_1937 world, class_2338 chunkloader) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.getWorld().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.getChunkLoader().equals((Object)chunkloader)).collect(Collectors.toList());
    }

    public boolean isChunkLoaded(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        return this.getLoadedChunk(world, chunkPos, chunkLoader).isPresent();
    }

    public boolean isChunkLoaded(class_1937 world, class_1923 chunkPos) {
        return this.getLoadedChunk(world, chunkPos).isPresent();
    }

    public void loadChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader, String player) {
        Validate.isTrue((!this.isChunkLoaded(world, chunkPos, chunkLoader) ? 1 : 0) != 0, (String)"chunk is already loaded", (Object[])new Object[0]);
        LoadedChunk loadedChunk = new LoadedChunk(chunkPos, ChunkLoaderManager.getWorldName(world), player, chunkLoader);
        this.loadedChunks.add(loadedChunk);
        class_3215 serverChunkManager = ((class_3218)world).method_14178();
        serverChunkManager.method_17297(CHUNK_LOADER, loadedChunk.getChunk(), 31, (Object)loadedChunk.getChunk());
        this.method_80();
    }

    public void unloadChunkLoader(class_1937 world, class_2338 chunkLoader) {
        this.getLoadedChunks(world, chunkLoader).forEach(loadedChunk -> this.unloadChunk(world, loadedChunk.getChunk(), chunkLoader));
    }

    public void unloadChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        Optional<LoadedChunk> optionalLoadedChunk = this.getLoadedChunk(world, chunkPos, chunkLoader);
        Validate.isTrue((boolean)optionalLoadedChunk.isPresent(), (String)"chunk is not loaded", (Object[])new Object[0]);
        LoadedChunk loadedChunk = optionalLoadedChunk.get();
        this.loadedChunks.remove(loadedChunk);
        if (!this.isChunkLoaded(world, loadedChunk.getChunk())) {
            class_3215 serverChunkManager = ((class_3218)world).method_14178();
            serverChunkManager.method_17300(CHUNK_LOADER, loadedChunk.getChunk(), 31, (Object)loadedChunk.getChunk());
        }
        this.method_80();
    }

    public static class_2960 getWorldName(class_1937 world) {
        return world.method_29287().method_29177();
    }

    public static class_5321<class_1937> getDimensionRegistryKey(class_1937 world) {
        return world.method_27983();
    }

    public void syncChunkLoaderToClient(class_3222 serverPlayerEntity, class_2338 chunkLoader) {
        this.syncToClient(serverPlayerEntity, this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.getChunkLoader().equals((Object)chunkLoader)).collect(Collectors.toList()));
    }

    public void syncAllToClient(class_3222 serverPlayerEntity) {
        this.syncToClient(serverPlayerEntity, this.loadedChunks);
    }

    public void clearClient(class_3222 serverPlayerEntity) {
        this.syncToClient(serverPlayerEntity, Collections.emptyList());
    }

    public void syncToClient(class_3222 serverPlayerEntity, List<LoadedChunk> chunks) {
        serverPlayerEntity.field_13987.method_14364(ClientBoundPackets.createPacketSyncLoadedChunks(chunks));
    }

    public static class LoadedChunk {
        public static Codec<class_1923> CHUNK_POS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(p -> p.field_9181), (App)Codec.INT.fieldOf("z").forGetter(p -> p.field_9180)).apply((Applicative)instance, class_1923::new));
        public static Codec<LoadedChunk> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CHUNK_POS_CODEC.fieldOf("chunk").forGetter(LoadedChunk::getChunk), (App)class_2960.field_25139.fieldOf("world").forGetter(LoadedChunk::getWorld), (App)Codec.STRING.fieldOf("player").forGetter(LoadedChunk::getPlayer), (App)class_2338.field_25064.fieldOf("chunkLoader").forGetter(LoadedChunk::getChunkLoader)).apply((Applicative)instance, LoadedChunk::new));
        private class_1923 chunk;
        private class_2960 world;
        private String player;
        private class_2338 chunkLoader;

        public LoadedChunk(class_1923 chunk, class_2960 world, String player, class_2338 chunkLoader) {
            this.chunk = chunk;
            this.world = world;
            this.player = player;
            this.chunkLoader = chunkLoader;
            Validate.isTrue((!StringUtils.isBlank((CharSequence)player) ? 1 : 0) != 0, (String)"Player cannot be blank", (Object[])new Object[0]);
        }

        public class_1923 getChunk() {
            return this.chunk;
        }

        public class_2960 getWorld() {
            return this.world;
        }

        public String getPlayer() {
            return this.player;
        }

        public class_2338 getChunkLoader() {
            return this.chunkLoader;
        }
    }
}

