/*
 * Decompiled with CFR 0.152.
 */
package reborncore;

import java.io.File;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.world.WorldTickCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reborncore.api.ToolManager;
import reborncore.common.RebornCoreCommands;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.config.Configuration;
import reborncore.common.crafting.ingredient.IngredientManager;
import reborncore.common.fluid.RebornFluidManager;
import reborncore.common.misc.ModSounds;
import reborncore.common.misc.RebornCoreTags;
import reborncore.common.multiblock.MultiblockRegistry;
import reborncore.common.network.ServerBoundPackets;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.CalenderUtils;
import reborncore.common.util.GenericWrenchHelper;

public class RebornCore
implements ModInitializer {
    public static final String MOD_NAME = "Reborn Core";
    public static final String MOD_ID = "reborncore";
    public static final String MOD_VERSION = "@MODVERSION@";
    public static final String WEB_URL = "https://files.modmuss50.me/";
    public static final Logger LOGGER = LogManager.getLogger((String)"reborncore");
    public static File configDir;
    public static boolean LOADED;

    public void onInitialize() {
        new Configuration(RebornCoreConfig.class, MOD_ID);
        configDir = new File(FabricLoader.getInstance().getConfigDirectory(), "teamreborn");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        PowerSystem.selectedFile = new File(configDir, "reborncore/selected_energy.json");
        PowerSystem.readFile();
        CalenderUtils.loadCalender();
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("ic2:wrench"), true));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("forestry:wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("actuallyadditions:item_laser_wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("thermalfoundation:wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("charset:wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("teslacorelib:wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("rftools:smartwrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("intergrateddynamics:smartwrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("correlated:weldthrower"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("chiselsandbits:wrench_wood"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("redstonearsenal:tool.wrench_flux"), false));
        ModSounds.setup();
        BlockWrenchEventHandler.setup();
        WorldTickCallback.EVENT.register(MultiblockRegistry::tickStart);
        ServerBoundPackets.init();
        IngredientManager.setup();
        RebornFluidManager.setupBucketMap();
        RebornCoreCommands.setup();
        RebornCoreTags.WATER_EXPLOSION_ITEM.toString();
        LOGGER.info("Reborn core is done for now, now to let other mods have their turn...");
        LOADED = true;
    }

    public static EnvType getSide() {
        return FabricLoader.getInstance().getEnvironmentType();
    }

    public static void clientOnly(Supplier<Runnable> runnable) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            runnable.get().run();
        }
    }

    static {
        LOADED = false;
    }
}

