/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import reborncore.RebornCore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.class_2338;

public class Torus {

	public static Map<Integer, Integer> TORUS_SIZE_MAP = new HashMap<>();

	public static List<class_2338> generate(class_2338 orgin, int radius) {
		List<class_2338> posLists = new ArrayList<>();
		for (int x = -radius; x < radius; x++) {
			for (int y = -radius; y < radius; y++) {
				for (int z = -radius; z < radius; z++) {
					if (Math.pow(radius / 2 - Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2)), 2) + Math.pow(z, 2) < Math.pow(radius * 0.05, 2)) {
						posLists.add(orgin.method_10069(x, z, y));
					}
				}
			}
		}
		return posLists;
	}

	public static void genSizeMap(int maxRadius) {
		if (!TORUS_SIZE_MAP.isEmpty()) {
			//Lets not do this again
			return;
		}
		long start = System.currentTimeMillis();
		IntStream.range(0, maxRadius + 10).parallel().forEach(radius -> { //10 is added as the control computer has a base of around 6 less
			int size = 0;
			for (int x = -radius; x < radius; x++) {
				for (int y = -radius; y < radius; y++) {
					for (int z = -radius; z < radius; z++) {
						if (Math.pow(radius / 2 - Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2)), 2) + Math.pow(z, 2) < Math.pow(radius * 0.05, 2)) {
							size++;
						}
					}
				}
			}
			TORUS_SIZE_MAP.put(radius, size);
		});
		RebornCore.LOGGER.info("Loaded torus size map in " + (System.currentTimeMillis() - start) + "ms");
	}

}
