/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.multiblock.rectangular;

import reborncore.common.multiblock.MultiblockControllerBase;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import reborncore.common.multiblock.MultiblockBlockEntityBase;
import reborncore.common.multiblock.MultiblockValidationException;

public abstract class RectangularMultiblockBlockEntityBase extends MultiblockBlockEntityBase {

	PartPosition position;
	class_2350 outwards;

	public RectangularMultiblockBlockEntityBase(class_2591<?> blockEntityType) {
		super(blockEntityType);

		position = PartPosition.Unknown;
		outwards = null;
	}

	// Positional Data
	public class_2350 getOutwardsDir() {
		return outwards;
	}

	public PartPosition getPartPosition() {
		return position;
	}

	// Handlers from MultiblockBlockEntityBase
	@Override
	public void onAttached(MultiblockControllerBase newController) {
		super.onAttached(newController);
		recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
	}

	@Override
	public void onMachineAssembled(MultiblockControllerBase controller) {
		class_2338 maxCoord = controller.getMaximumCoord();
		class_2338 minCoord = controller.getMinimumCoord();

		// Discover where I am on the reactor
		recalculateOutwardsDirection(minCoord, maxCoord);
	}

	@Override
	public void onMachineBroken() {
		position = PartPosition.Unknown;
		outwards = null;
	}

	// Positional helpers
	public void recalculateOutwardsDirection(class_2338 minCoord, class_2338 maxCoord) {
		outwards = null;
		position = PartPosition.Unknown;

		int facesMatching = 0;
		if (maxCoord.method_10263() == this.method_11016().method_10263() || minCoord.method_10263() == this.method_11016().method_10263()) {
			facesMatching++;
		}
		if (maxCoord.method_10264() == this.method_11016().method_10264() || minCoord.method_10264() == this.method_11016().method_10264()) {
			facesMatching++;
		}
		if (maxCoord.method_10260() == this.method_11016().method_10260() || minCoord.method_10260() == this.method_11016().method_10260()) {
			facesMatching++;
		}

		if (facesMatching <= 0) {
			position = PartPosition.Interior;
		} else if (facesMatching >= 3) {
			position = PartPosition.FrameCorner;
		} else if (facesMatching == 2) {
			position = PartPosition.Frame;
		} else {
			// 1 face matches
			if (maxCoord.method_10263() == this.method_11016().method_10263()) {
				position = PartPosition.EastFace;
				outwards = class_2350.field_11034;
			} else if (minCoord.method_10263() == this.method_11016().method_10263()) {
				position = PartPosition.WestFace;
				outwards = class_2350.field_11039;
			} else if (maxCoord.method_10260() == this.method_11016().method_10260()) {
				position = PartPosition.SouthFace;
				outwards = class_2350.field_11035;
			} else if (minCoord.method_10260() == this.method_11016().method_10260()) {
				position = PartPosition.NorthFace;
				outwards = class_2350.field_11043;
			} else if (maxCoord.method_10264() == this.method_11016().method_10264()) {
				position = PartPosition.TopFace;
				outwards = class_2350.field_11036;
			} else {
				position = PartPosition.BottomFace;
				outwards = class_2350.field_11033;
			}
		}
	}

	// /// Validation Helpers (IMultiblockPart)
	public abstract void isGoodForFrame() throws MultiblockValidationException;

	public abstract void isGoodForSides() throws MultiblockValidationException;

	public abstract void isGoodForTop() throws MultiblockValidationException;

	public abstract void isGoodForBottom() throws MultiblockValidationException;

	public abstract void isGoodForInterior() throws MultiblockValidationException;
}
