/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import reborncore.mixin.common.AccessorIngredient;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;

public class WrappedIngredient extends RebornIngredient {
	private class_1856 wrapped;

	public WrappedIngredient() {
		super(IngredientManager.WRAPPED_RECIPE_TYPE);
	}

	public WrappedIngredient(class_1856 wrapped) {
		this();
		this.wrapped = wrapped;
	}

	@Override
	public boolean test(class_1799 itemStack) {
		return wrapped.method_8093(itemStack);
	}

	@Override
	public class_1856 getPreview() {
		return wrapped;
	}

	@Override
	public List<class_1799> getPreviewStacks() {
		return Arrays.asList(((AccessorIngredient) (Object) wrapped).getMatchingStacks());
	}

	@Override
	protected JsonObject toJson() {
		if (wrapped.method_8089() instanceof JsonObject) {
			return (JsonObject) wrapped.method_8089();
		}
		JsonObject jsonObject = new JsonObject();
		jsonObject.add("options", wrapped.method_8089());
		return jsonObject;
	}

	@Override
	public int getCount() {
		return ((AccessorIngredient) (Object) wrapped).getMatchingStacks().length;
	}

	public static RebornIngredient deserialize(JsonObject jsonObject) {
		class_1856 underlying;
		if (jsonObject.has("options") && jsonObject.get("options") instanceof JsonArray) {
			underlying = class_1856.method_8102(jsonObject.get("options"));
		} else {
			underlying = class_1856.method_8102(jsonObject);
		}
		return new WrappedIngredient(underlying);
	}
}
