/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.screen.builder.slot;

import com.mojang.datafixers.util.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1263;
import net.minecraft.class_2960;
import javax.annotation.Nullable;

public class SpriteSlot extends FilteredSlot {

	private final class_2960 spriteName;
	int stacksize;

	public SpriteSlot(final class_1263 inventory, final int index, final int xPosition, final int yPosition, final class_2960 sprite, final int stacksize) {
		super(inventory, index, xPosition, yPosition);
		this.spriteName = sprite;
		this.stacksize = stacksize;
	}

	public SpriteSlot(final class_1263 inventory, final int index, final int xPosition, final int yPosition, final class_2960 sprite) {
		this(inventory, index, xPosition, yPosition, sprite, 64);
	}

	@Override
	public int method_7675() {
		return this.stacksize;
	}

	@Override
	@Nullable
	@Environment(EnvType.CLIENT)
	public Pair<class_2960, class_2960> method_7679() {
		return Pair.of(class_1059.field_5275, spriteName);
	}
}
