/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui.builder.slot.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.SlotConfigGui;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.common.blockentity.SlotConfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_918;

public class ConfigSlotElement extends ElementBase {
	SlotType type;
	class_1263 inventory;
	int id;
	public List<ElementBase> elements = new ArrayList<>();
	boolean filter = false;

	public ConfigSlotElement(class_1263 slotInventory, int slotId, SlotType type, int x, int y, GuiBase<?> gui) {
		super(x, y, type.getButtonSprite());
		this.type = type;
		this.inventory = slotInventory;
		this.id = slotId;

		SlotConfigPopupElement popupElement;

		boolean inputEnabled = gui.builtScreenHandler.field_7761.stream()
				.filter(Objects::nonNull)
				.filter(slot -> slot.field_7871 == inventory)
				.filter(slot -> slot instanceof BaseSlot)
				.map(slot -> (BaseSlot) slot)
				.filter(baseSlot -> baseSlot.getSlotID() == slotId)
				.allMatch(BaseSlot::canWorldBlockInsert);


		elements.add(popupElement = new SlotConfigPopupElement(this.id, x - 22, y - 22, this, inputEnabled));
		elements.add(new ButtonElement(x + 37, y - 25, Sprite.EXIT_BUTTON).addReleaseAction((element, gui1, provider, mouseX, mouseY) -> {
			SlotConfigGui.selectedSlot = -1;
			gui.closeSelectedTab();
			return true;
		}));

		if (inputEnabled) {
			elements.add(new CheckBoxElement(new class_2585("Auto Input"), 0xFFFFFFFF, x - 26, y + 42, "input", slotId, Sprite.LIGHT_CHECK_BOX, gui.getMachine(),
					checkBoxElement -> checkBoxElement.machineBase.getSlotConfiguration().getSlotDetails(checkBoxElement.slotID).autoInput()).addPressAction((element, gui12, provider, mouseX, mouseY) -> {
				popupElement.updateCheckBox((CheckBoxElement) element, "input", gui12);
				return true;
			}));
		}

		elements.add(new CheckBoxElement(new class_2585("Auto Output"), 0xFFFFFFFF, x - 26, y + 57, "output", slotId, Sprite.LIGHT_CHECK_BOX, gui.getMachine(),
				checkBoxElement -> checkBoxElement.machineBase.getSlotConfiguration().getSlotDetails(checkBoxElement.slotID).autoOutput()).addPressAction((element, gui13, provider, mouseX, mouseY) -> {
			popupElement.updateCheckBox((CheckBoxElement) element, "output", gui13);
			return true;
		}));

		if (gui.getMachine() instanceof SlotConfiguration.SlotFilter) {
			SlotConfiguration.SlotFilter slotFilter = (SlotConfiguration.SlotFilter) gui.getMachine();
			if (Arrays.stream(slotFilter.getInputSlots()).anyMatch(value -> value == slotId)) {
				elements.add(new CheckBoxElement(new class_2585("Filter Input"), 0xFFFFFFFF, x - 26, y + 72, "filter", slotId, Sprite.LIGHT_CHECK_BOX, gui.getMachine(),
						checkBoxElement -> checkBoxElement.machineBase.getSlotConfiguration().getSlotDetails(checkBoxElement.slotID).filter()).addPressAction((element, gui13, provider, mouseX, mouseY) -> {
					popupElement.updateCheckBox((CheckBoxElement) element, "filter", gui13);
					return true;
				}));
				filter = true;
				popupElement.filter = true;
			}
		}
		setWidth(85);
		setHeight(105 + (filter ? 15 : 0));
	}

	@Override
	public void draw(class_4587 matrixStack, GuiBase<?> gui) {
		super.draw(matrixStack, gui);
		class_1799 stack = inventory.method_5438(id);
		int xPos = x + 1 + gui.getGuiLeft();
		int yPos = y + 1 + gui.getGuiTop();

		RenderSystem.enableDepthTest();
		RenderSystem.pushMatrix();
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(class_4493.class_4535.field_22541, class_4493.class_4534.field_22523);
		class_918 renderItem = class_310.method_1551().method_1480();
		renderItem.method_4023(stack, xPos, yPos);
		renderItem.method_4022(gui.getTextRenderer(), stack, xPos, yPos, null);
		RenderSystem.disableDepthTest();
		RenderSystem.disableLighting();
		RenderSystem.popMatrix();
		if (isHovering) {
			drawSprite(matrixStack, gui, type.getButtonHoverOverlay(), x, y);
		}
		elements.forEach(elementBase -> elementBase.draw(matrixStack, gui));
	}

	public SlotType getType() {
		return type;
	}

	public int getId() {
		return id;
	}
}