/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ToolManager implements ICustomToolHandler {

	public static final ToolManager INSTANCE = new ToolManager();
	public List<ICustomToolHandler> customToolHandlerList = new ArrayList<>();

	@Override
	public boolean handleTool(class_1799 stack, class_2338 pos, class_1937 world, class_1657 player, class_2350 side, boolean damage) {
		if (stack == null || stack.method_7960()) {
			return false;
		}
		if (stack.method_7909() instanceof IToolHandler) {
			return ((IToolHandler) stack.method_7909()).handleTool(stack, pos, world, player, side, damage);
		}
		for (ICustomToolHandler customToolHandler : customToolHandlerList) {
			if (customToolHandler.canHandleTool(stack)) {
				return customToolHandler.handleTool(stack, pos, world, player, side, damage);
			}
		}
		return false;
	}

	@Override
	public boolean canHandleTool(class_1799 stack) {
		if (stack == null || stack.method_7960()) {
			return false;
		}
		if (stack.method_7909() instanceof IToolHandler) {
			return true;
		}
		for (ICustomToolHandler customToolHandler : customToolHandlerList) {
			if (customToolHandler.canHandleTool(stack)) {
				return true;
			}
		}
		return false;
	}
}
