/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.apache.commons.lang3.Validate;
import reborncore.api.items.InventoryBase;

public class InventoryItem
extends InventoryBase {
    @Nonnull
    class_1799 stack;
    int size;

    private InventoryItem(@Nonnull class_1799 stack, int size) {
        super(size);
        Validate.notNull((Object)stack);
        Validate.isTrue((!stack.method_7960() ? 1 : 0) != 0);
        this.size = size;
        this.stack = stack;
    }

    public static InventoryItem getItemInvetory(class_1799 stack, int size) {
        return new InventoryItem(stack, size);
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public class_2487 getInvData() {
        Validate.isTrue((!this.stack.method_7960() ? 1 : 0) != 0);
        if (!this.stack.method_7985()) {
            this.stack.method_7980(new class_2487());
        }
        if (!this.stack.method_7969().method_10545("inventory")) {
            this.stack.method_7969().method_10566("inventory", (class_2520)new class_2487());
        }
        return this.stack.method_7969().method_10562("inventory");
    }

    public class_2487 getSlotData(int slot) {
        this.validateSlotIndex(slot);
        class_2487 invData = this.getInvData();
        if (!invData.method_10545("slot_" + slot)) {
            invData.method_10566("slot_" + slot, (class_2520)new class_2487());
        }
        return invData.method_10562("slot_" + slot);
    }

    public void setSlotData(int slot, class_2487 tagCompound) {
        this.validateSlotIndex(slot);
        Validate.notNull((Object)tagCompound);
        class_2487 invData = this.getInvData();
        invData.method_10566("slot_" + slot, (class_2520)tagCompound);
    }

    public List<class_1799> getAllStacks() {
        return IntStream.range(0, this.size).mapToObj(this::method_5438).collect(Collectors.toList());
    }

    public int getSlots() {
        return this.size;
    }

    @Override
    @Nonnull
    public class_1799 method_5438(int slot) {
        return class_1799.method_7915((class_2487)this.getSlotData(slot));
    }

    @Override
    public void method_5447(int slot, @Nonnull class_1799 stack) {
        this.setSlotData(slot, stack.method_7953(new class_2487()));
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    public int getStackLimit(int slot, @Nonnull class_1799 stack) {
        return Math.min(this.getSlotLimit(slot), stack.method_7914());
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return true;
    }
}

