/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import org.apache.commons.lang3.Validate;

public final class ConditionManager {
    private static final HashMap<class_2960, RecipeCondition<?>> RECIPE_CONDITIONS = new HashMap();
    private static final HashMap<class_2960, Class<?>> RECIPE_CONDITION_TYPES = new HashMap();

    private static boolean registryContains(class_2370<?> registry, class_2960 ident) {
        return registry.method_10250(ident);
    }

    public static <T> void register(String name, Class<T> type, RecipeCondition<T> recipeCondition) {
        ConditionManager.register(new class_2960("reborncore", name), type, recipeCondition);
    }

    public static <T> void register(class_2960 identifier, Class<T> type, RecipeCondition<T> recipeCondition) {
        Validate.isTrue((!RECIPE_CONDITIONS.containsKey(identifier) ? 1 : 0) != 0, (String)"Recipe condition already registered", (Object[])new Object[0]);
        RECIPE_CONDITIONS.put(identifier, recipeCondition);
        RECIPE_CONDITION_TYPES.put(identifier, type);
    }

    public static RecipeCondition<?> getRecipeCondition(class_2960 identifier) {
        RecipeCondition<?> condition = RECIPE_CONDITIONS.get(identifier);
        if (condition == null) {
            throw new UnsupportedOperationException("Could not find recipe condition for " + identifier.toString());
        }
        return condition;
    }

    public static boolean shouldLoadRecipe(JsonObject jsonObject) {
        if (!jsonObject.has("conditions")) {
            return true;
        }
        return jsonObject.get("conditions").getAsJsonObject().entrySet().stream().allMatch(entry -> ConditionManager.shouldLoad((String)entry.getKey(), (JsonElement)entry.getValue()));
    }

    public static boolean shouldLoad(String ident, JsonElement jsonElement) {
        class_2960 identifier = ConditionManager.parseIdent(ident);
        RecipeCondition<?> recipeCondition = ConditionManager.getRecipeCondition(identifier);
        Class<?> type = RECIPE_CONDITION_TYPES.get(identifier);
        return ConditionManager.shouldLoad(type, jsonElement, recipeCondition);
    }

    private static boolean shouldLoad(Class type, JsonElement jsonElement, RecipeCondition recipeCondition) {
        Object val = TypeHelper.getValue(type, jsonElement);
        return recipeCondition.shouldLoad(val);
    }

    private static class_2960 parseIdent(String string) {
        if (string.contains(":")) {
            return new class_2960(string);
        }
        return new class_2960("reborncore", string);
    }

    static {
        ConditionManager.register("development", Boolean.class, (T bool) -> bool.booleanValue() == FabricLoader.getInstance().isDevelopmentEnvironment());
        ConditionManager.register("item", class_2960.class, (T id) -> ConditionManager.registryContains(class_2378.field_11142, id));
        ConditionManager.register("fluid", class_2960.class, (T id) -> ConditionManager.registryContains(class_2378.field_11154, id));
        ConditionManager.register("tag", class_2960.class, (T s) -> class_3489.method_15106().method_15196().containsKey(s));
        ConditionManager.register("mod", String.class, (T s) -> FabricLoader.getInstance().isModLoaded(s));
    }

    private static class TypeHelper {
        private static final HashMap<Class<?>, Function<JsonElement, ?>> FUNCTIONS = new HashMap();

        private TypeHelper() {
        }

        private static <T> void register(Class<T> type, Function<JsonElement, T> function) {
            Validate.isTrue((!FUNCTIONS.containsKey(type) ? 1 : 0) != 0, (String)"Function for this class is already registered", (Object[])new Object[0]);
            FUNCTIONS.put(type, function);
        }

        public static <T> T getValue(Class<T> type, JsonElement jsonElement) {
            Validate.isTrue((boolean)FUNCTIONS.containsKey(type), (String)"Function for this class could not be found", (Object[])new Object[0]);
            return (T)FUNCTIONS.get(type).apply(jsonElement);
        }

        static {
            TypeHelper.register(String.class, JsonElement::getAsString);
            TypeHelper.register(Boolean.class, JsonElement::getAsBoolean);
            TypeHelper.register(class_2960.class, element -> new class_2960(element.getAsString()));
        }
    }

    @FunctionalInterface
    public static interface RecipeCondition<T> {
        public boolean shouldLoad(T var1);
    }
}

