/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.hud;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_918;
import org.lwjgl.opengl.GL11;
import reborncore.client.hud.StackInfoElement;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergyHolder;

public class StackInfoHUD
implements HudRenderCallback {
    public static List<StackInfoElement> ELEMENTS = new ArrayList<StackInfoElement>();
    private static class_310 mc = class_310.method_1551();
    private int x = 2;
    private int y = 7;

    public static void registerElement(StackInfoElement element) {
        ELEMENTS.add(element);
    }

    public void drawStackInfoHud(class_4587 matrixStack, class_1041 res) {
        class_746 player = StackInfoHUD.mc.field_1724;
        if (player == null) {
            return;
        }
        List stacks = new ArrayList<class_1799>();
        stacks.add(player.method_6047());
        stacks.add(player.method_6079());
        for (class_1799 stack : player.method_5661()) {
            stacks.add(stack);
        }
        this.x = RebornCoreConfig.stackInfoX;
        if (RebornCoreConfig.stackInfoCorner == 2 || RebornCoreConfig.stackInfoCorner == 3) {
            stacks = Lists.reverse(stacks);
            this.y = res.method_4502() - 20 - RebornCoreConfig.stackInfoY;
        } else {
            this.y = RebornCoreConfig.stackInfoY;
        }
        for (class_1799 stack : stacks) {
            this.addInfo(matrixStack, stack, res);
        }
    }

    private void addInfo(class_4587 matrixStack, class_1799 stack, class_1041 res) {
        if (stack == class_1799.field_8037) {
            return;
        }
        if (stack.method_7909() instanceof EnergyHolder) {
            double maxCharge = Energy.of((Object)stack).getMaxStored();
            double currentCharge = Energy.of((Object)stack).getEnergy();
            class_124 color = StringUtils.getPercentageColour(this.percentage(maxCharge, currentCharge));
            class_5250 text = new class_2585(PowerSystem.getLocaliszedPowerFormattedNoSuffix(currentCharge)).method_27692(color).method_27693("/").method_27693(PowerSystem.getLocaliszedPowerFormattedNoSuffix(maxCharge)).method_27693(" ").method_27693(PowerSystem.getDisplayPower().abbreviation);
            if (stack.method_7969() != null && stack.method_7969().method_10545("isActive")) {
                if (stack.method_7969().method_10577("isActive")) {
                    text.method_27692(class_124.field_1065).method_27693(" (").method_10852((class_2561)new class_2588("reborncore.message.active")).method_27693(")");
                } else {
                    text.method_27692(class_124.field_1065).method_27693(" (").method_10852((class_2561)new class_2588("reborncore.message.inactive")).method_27693(")");
                }
            }
            if (RebornCoreConfig.stackInfoCorner == 1 || RebornCoreConfig.stackInfoCorner == 2) {
                int strWidth = StackInfoHUD.mc.field_1772.method_27525((class_5348)text);
                this.x = res.method_4486() - strWidth - 18 - RebornCoreConfig.stackInfoX;
            }
            this.renderStackForInfo(matrixStack, stack);
            StackInfoHUD.mc.field_1772.method_27528(matrixStack, (class_5348)text, (float)(this.x + 18), (float)this.y, 0);
            this.y = RebornCoreConfig.stackInfoCorner == 0 || RebornCoreConfig.stackInfoCorner == 1 ? (this.y += 20) : (this.y -= 20);
        }
        for (StackInfoElement element : ELEMENTS) {
            if (element.getText(stack).equals("")) continue;
            this.renderStackForInfo(matrixStack, stack);
            StackInfoHUD.mc.field_1772.method_27528(matrixStack, (class_5348)element.getText(stack), (float)(this.x + 18), (float)this.y, 0);
            this.y += 20;
        }
    }

    private void renderStackForInfo(class_4587 matrixStack, class_1799 stack) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        class_308.method_22890();
        if (stack.method_7960()) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        class_918 itemRenderer = class_310.method_1551().method_1480();
        itemRenderer.method_4023(stack, this.x, this.y - 5);
        GL11.glDisable((int)2896);
    }

    private int percentage(double MaxValue, double CurrentValue) {
        if (CurrentValue == 0.0) {
            return 0;
        }
        return (int)(CurrentValue * 100.0 / MaxValue);
    }

    public void onHudRender(class_4587 matrixStack, float tickDelta) {
        if (StackInfoHUD.mc.field_1690.field_1842) {
            return;
        }
        if (!RebornCoreConfig.ShowStackInfoHUD) {
            return;
        }
        if (mc.method_1569() || StackInfoHUD.mc.field_1755 != null && StackInfoHUD.mc.field_1690.field_1866) {
            this.drawStackInfoHud(matrixStack, mc.method_22683());
        }
    }
}

