/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.guibuilder;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3612;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import reborncore.api.IListInfoProvider;
import reborncore.client.RenderUtil;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.GuiTab;
import reborncore.common.fluid.FluidUtil;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;

public class GuiBuilder {
    public static final class_2960 defaultTextureSheet = new class_2960("reborncore", "textures/gui/guielements.png");
    private static final class_2561 SPACE_TEXT = new class_2585(" ");
    static class_2960 resourceLocation;

    public GuiBuilder() {
        resourceLocation = defaultTextureSheet;
    }

    public GuiBuilder(class_2960 resourceLocation) {
        GuiBuilder.resourceLocation = resourceLocation;
    }

    public class_2960 getResourceLocation() {
        return resourceLocation;
    }

    public void drawDefaultBackground(class_4587 matrixStack, class_437 gui, int x, int y, int width, int height) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310.method_1551().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 0, 0, width / 2, height / 2);
        gui.method_25302(matrixStack, x + width / 2, y, 150 - width / 2, 0, width / 2, height / 2);
        gui.method_25302(matrixStack, x, y + height / 2, 0, 150 - height / 2, width / 2, height / 2);
        gui.method_25302(matrixStack, x + width / 2, y + height / 2, 150 - width / 2, 150 - height / 2, width / 2, height / 2);
    }

    public void drawPlayerSlots(class_4587 matrixStack, class_437 gui, int posX, int posY, boolean center) {
        class_310.method_1551().method_1531().method_22813(resourceLocation);
        if (center) {
            posX -= 81;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                gui.method_25302(matrixStack, posX + x * 18, posY + y * 18, 150, 0, 18, 18);
            }
        }
        for (int x = 0; x < 9; ++x) {
            gui.method_25302(matrixStack, posX + x * 18, posY + 58, 150, 0, 18, 18);
        }
    }

    public void drawSlot(class_4587 matrixStack, class_437 gui, int posX, int posY) {
        class_310.method_1551().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, posX, posY, 150, 0, 18, 18);
    }

    public void drawText(class_4587 matrixStack, GuiBase<?> gui, class_2561 text, int x, int y, int color) {
        gui.getTextRenderer().method_27528(matrixStack, (class_5348)text, (float)x, (float)y, color);
    }

    public void drawProgressBar(class_4587 matrixStack, GuiBase<?> gui, double progress, int x, int y) {
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 150, 18, 22, 15);
        int j = (int)progress;
        if (j > 0) {
            gui.method_25302(matrixStack, x, y, 150, 34, j + 1, 15);
        }
    }

    public void drawOutputSlot(class_4587 matrixStack, GuiBase<?> gui, int x, int y) {
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 174, 0, 26, 26);
    }

    public void drawJEIButton(class_4587 matrixStack, GuiBase<?> gui, int x, int y, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (FabricLoader.getInstance().isModLoaded("jei")) {
            if (layer == GuiBase.Layer.BACKGROUND) {
                x += gui.getGuiLeft();
                y += gui.getGuiTop();
            }
            gui.getMinecraft().method_1531().method_22813(resourceLocation);
            gui.method_25302(matrixStack, x, y, 202, 0, 12, 12);
        }
    }

    public void drawLockButton(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer, boolean locked) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 174, 26 + (locked ? 12 : 0), 20, 12);
        if (gui.isPointInRect(x, y, 20, 12, mouseX, mouseY)) {
            ArrayList<class_2588> list = new ArrayList<class_2588>();
            if (locked) {
                list.add(new class_2588("reborncore.gui.tooltip.unlock_items"));
            } else {
                list.add(new class_2588("reborncore.gui.tooltip.lock_items"));
            }
            RenderSystem.pushMatrix();
            gui.method_25417(matrixStack, list, mouseX, mouseY);
            RenderSystem.popMatrix();
        }
    }

    public void drawHologramButton(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer) {
        if (gui.isTabOpen()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        if (gui.getMachine().renderMultiblock == null) {
            gui.method_25302(matrixStack, x, y, 174, 50, 20, 12);
        } else {
            gui.method_25302(matrixStack, x, y, 174, 62, 20, 12);
        }
        if (gui.isPointInRect(x, y, 20, 12, mouseX, mouseY)) {
            ArrayList<class_2588> list = new ArrayList<class_2588>();
            list.add(new class_2588("reborncore.gui.tooltip.hologram"));
            RenderSystem.pushMatrix();
            if (layer == GuiBase.Layer.FOREGROUND) {
                mouseX -= gui.getGuiLeft();
                mouseY -= gui.getGuiTop();
            }
            gui.method_25417(matrixStack, list, mouseX, mouseY);
            RenderSystem.popMatrix();
        }
    }

    public void drawBigHeatBar(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int value, int max, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 26, 218, 114, 18);
        if (value != 0) {
            int j = (int)((double)value / (double)max * 106.0);
            if (j < 0) {
                j = 0;
            }
            gui.method_25302(matrixStack, x + 4, y + 4, 26, 246, j, 10);
            class_5250 text = new class_2585(String.valueOf(value)).method_10852((class_2561)new class_2588("reborncore.gui.heat"));
            gui.drawCentredText(matrixStack, (class_2561)text, y + 5, 0xFFFFFF, layer);
        }
    }

    public void drawBigBlueBar(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int value, int max, int mouseX, int mouseY, String suffix, class_2561 line2, String format, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        int j = (int)((double)value / (double)max * 106.0);
        if (j < 0) {
            j = 0;
        }
        gui.method_25302(matrixStack, x + 4, y + 4, 0, 236, j, 10);
        if (!suffix.equals("")) {
            suffix = " " + suffix;
        }
        gui.drawCentredText(matrixStack, (class_2561)new class_2585(format).method_27693(suffix), y + 5, 0xFFFFFF, layer);
        if (gui.isPointInRect(x, y, 114, 18, mouseX, mouseY)) {
            int percentage = this.percentage(max, value);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new class_2585(String.valueOf(value)).method_27692(class_124.field_1065).method_27693("/").method_27693(String.valueOf(max)).method_27693(suffix));
            list.add(new class_2585(String.valueOf(percentage)).method_27692(StringUtils.getPercentageColour(percentage)).method_27693("%").method_10852((class_2561)new class_2588("reborncore.gui.tooltip.dsu_fullness").method_27692(class_124.field_1080)));
            list.add(line2);
            if (value > max) {
                list.add(new class_2585("Yo this is storing more than it should be able to").method_27692(class_124.field_1080));
                list.add(new class_2585("prolly a bug").method_27692(class_124.field_1080));
                list.add(new class_2585("pls report and tell how tf you did this").method_27692(class_124.field_1080));
            }
            if (layer == GuiBase.Layer.FOREGROUND) {
                mouseX -= gui.getGuiLeft();
                mouseY -= gui.getGuiTop();
            }
            gui.method_25417(matrixStack, list, mouseX, mouseY);
            RenderSystem.disableLighting();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawBigBlueBar(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int value, int max, int mouseX, int mouseY, String suffix, GuiBase.Layer layer) {
        this.drawBigBlueBar(matrixStack, gui, x, y, value, max, mouseX, mouseY, suffix, class_2585.field_24366, Integer.toString(value), layer);
    }

    public void drawBigBlueBar(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int value, int max, int mouseX, int mouseY, GuiBase.Layer layer) {
        this.drawBigBlueBar(matrixStack, gui, x, y, value, max, mouseX, mouseY, "", class_2585.field_24366, "", layer);
    }

    public void drawMultiblockMissingBar(class_4587 matrixStack, GuiBase<?> gui, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        int x = 0;
        int y = 4;
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        RenderSystem.disableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderUtil.drawGradientRect(0, x, y, x + 176, y + 20, 0, -1073741824);
        RenderUtil.drawGradientRect(0, x, y + 20, x + 176, y + 20 + 48, -1073741824, -1073741824);
        RenderUtil.drawGradientRect(0, x, y + 68, x + 176, y + 70 + 20, -1073741824, 0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.disableDepthTest();
        gui.drawCentredText(matrixStack, (class_2561)new class_2588("reborncore.gui.missingmultiblock"), 43, 0xFFFFFF, layer);
    }

    public void drawUpgrades(class_4587 matrixStack, GuiBase<?> gui, int x, int y) {
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 217, 0, 24, 81);
    }

    public void drawSlotTab(class_4587 matrixStack, GuiBase<?> gui, int x, int y, class_1799 stack) {
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 217, 82, 24, 24);
        gui.getMinecraft().method_1480().method_4023(stack, x + 5, y + 4);
    }

    public void drawSlotConfigTips(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int mouseX, int mouseY, GuiTab guiTab) {
        List<class_2561> tips = guiTab.getTips().stream().map(class_2588::new).collect(Collectors.toList());
        TipsListWidget explanation = new TipsListWidget(gui, gui.getScreenWidth() - 14, 54, y, y + 76, 11, tips);
        explanation.method_25333(x - 81);
        explanation.method_25394(matrixStack, mouseX, mouseY, 1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawEnergyOutput(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int maxOutput, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        class_5250 text = new class_2585(PowerSystem.getLocaliszedPowerFormattedNoSuffix(maxOutput)).method_10852(SPACE_TEXT).method_27693(PowerSystem.getDisplayPower().abbreviation).method_27693("\t");
        int width = gui.getTextRenderer().method_27525((class_5348)text);
        gui.drawText(matrixStack, (class_2561)text, x - width - 2, y + 5, 0, layer);
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 150, 91, 16, 16);
    }

    public void drawProgressBar(class_4587 matrixStack, GuiBase<?> gui, int progress, int maxProgress, int x, int y, int mouseX, int mouseY, ProgressDirection direction, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, direction.x, direction.y, direction.width, direction.height);
        int j = (int)((double)progress / (double)maxProgress * 16.0);
        if (j < 0) {
            j = 0;
        }
        switch (direction) {
            case RIGHT: {
                gui.method_25302(matrixStack, x, y, direction.xActive, direction.yActive, j, 10);
                break;
            }
            case LEFT: {
                gui.method_25302(matrixStack, x + 16 - j, y, direction.xActive + 16 - j, direction.yActive, j, 10);
                break;
            }
            case UP: {
                gui.method_25302(matrixStack, x, y + 16 - j, direction.xActive, direction.yActive + 16 - j, 10, j);
                break;
            }
            case DOWN: {
                gui.method_25302(matrixStack, x, y, direction.xActive, direction.yActive, 10, j);
                break;
            }
            default: {
                return;
            }
        }
        if (gui.isPointInRect(x, y, direction.width, direction.height, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            list.add(new class_2585(String.valueOf(percentage)).method_27692(StringUtils.getPercentageColour(percentage)).method_27693("%"));
            if (layer == GuiBase.Layer.FOREGROUND) {
                mouseX -= gui.getGuiLeft();
                mouseY -= gui.getGuiTop();
            }
            gui.method_25417(matrixStack, list, mouseX, mouseY);
            RenderSystem.disableLighting();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawMultiEnergyBar(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int energyStored, int maxEnergyStored, int mouseX, int mouseY, int buttonID, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        PowerSystem.EnergySystem displayPower = PowerSystem.getDisplayPower();
        class_310.method_1551().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, displayPower.xBar - 15, displayPower.yBar - 1, 14, 50);
        int draw = (int)((double)energyStored / (double)maxEnergyStored * 48.0);
        if (energyStored > maxEnergyStored) {
            draw = 48;
        }
        gui.method_25302(matrixStack, x + 1, y + 49 - draw, displayPower.xBar, 48 + displayPower.yBar - draw, 12, draw);
        int percentage = this.percentage(maxEnergyStored, energyStored);
        if (gui.isPointInRect(x + 1, y + 1, 11, 48, mouseX, mouseY)) {
            ArrayList list = Lists.newArrayList();
            list.add(new class_2585(PowerSystem.getLocaliszedPowerFormattedNoSuffix(energyStored)).method_27692(class_124.field_1065).method_27693("/").method_27693(PowerSystem.getLocaliszedPowerFormattedNoSuffix(maxEnergyStored)).method_10852(SPACE_TEXT).method_27693(displayPower.abbreviation));
            list.add(StringUtils.getPercentageText(percentage).method_10852(SPACE_TEXT).method_10852((class_2561)new class_2588("reborncore.gui.tooltip.power_charged").method_27692(class_124.field_1080)));
            if (gui.be instanceof IListInfoProvider) {
                if (class_437.method_25442()) {
                    ((IListInfoProvider)gui.be).addInfo(list, true, true);
                } else {
                    list.add(class_2585.field_24366);
                    list.add(new class_2585("Shift").method_27692(class_124.field_1078).method_10852(SPACE_TEXT).method_27692(class_124.field_1080).method_10852((class_2561)new class_2588("reborncore.gui.tooltip.power_moreinfo")));
                }
            }
            if (layer == GuiBase.Layer.FOREGROUND) {
                mouseX -= gui.getGuiLeft();
                mouseY -= gui.getGuiTop();
            }
            gui.method_25417(matrixStack, list, mouseX, mouseY);
            RenderSystem.disableLighting();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawTank(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int mouseX, int mouseY, FluidInstance fluid, FluidValue maxCapacity, boolean isTankEmpty, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        int percentage = 0;
        FluidValue amount = FluidValue.EMPTY;
        if (!isTankEmpty) {
            amount = fluid.getAmount();
            percentage = this.percentage(maxCapacity.getRawValue(), amount.getRawValue());
        }
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 194, 26, 22, 56);
        if (!isTankEmpty) {
            this.drawFluid(matrixStack, gui, fluid, x + 4, y + 4, 14, 48, maxCapacity.getRawValue());
        }
        gui.method_25302(matrixStack, x + 3, y + 3, 194, 82, 16, 50);
        if (gui.isPointInRect(x, y, 22, 56, mouseX, mouseY)) {
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            if (isTankEmpty) {
                list.add(new class_2588("reborncore.gui.tooltip.tank_empty").method_27692(class_124.field_1065));
            } else {
                list.add(new class_2585(String.format("%s / %s", amount, maxCapacity)).method_27692(class_124.field_1065).method_10852(SPACE_TEXT).method_27693(FluidUtil.getFluidName(fluid)));
            }
            list.add(StringUtils.getPercentageText(percentage).method_27692(class_124.field_1080).method_10852(SPACE_TEXT).method_10852((class_2561)new class_2588("reborncore.gui.tooltip.tank_fullness")));
            if (layer == GuiBase.Layer.FOREGROUND) {
                mouseX -= gui.getGuiLeft();
                mouseY -= gui.getGuiTop();
            }
            gui.method_25417(matrixStack, list, mouseX, mouseY);
            RenderSystem.disableLighting();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawFluid(class_4587 matrixStack, GuiBase<?> gui, FluidInstance fluid, int x, int y, int width, int height, int maxCapacity) {
        int curHeight;
        if (fluid.getFluid() == class_3612.field_15906) {
            return;
        }
        gui.getMinecraft().method_1531().method_22813(class_1059.field_5275);
        y += height;
        class_1058 sprite = FluidRenderHandlerRegistry.INSTANCE.get(fluid.getFluid()).getFluidSprites((class_1920)gui.getMachine().method_10997(), gui.getMachine().method_11016(), fluid.getFluid().method_15785())[0];
        int color = FluidRenderHandlerRegistry.INSTANCE.get(fluid.getFluid()).getFluidColor((class_1920)gui.getMachine().method_10997(), gui.getMachine().method_11016(), fluid.getFluid().method_15785());
        int drawHeight = (int)((float)fluid.getAmount().getRawValue() / ((float)maxCapacity * 1.0f) * (float)height);
        int iconHeight = sprite.method_4595();
        RenderSystem.color3f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        int iteration = 0;
        for (int offsetHeight = drawHeight; offsetHeight != 0; offsetHeight -= curHeight) {
            curHeight = offsetHeight < iconHeight ? offsetHeight : iconHeight;
            class_332.method_25298((class_4587)matrixStack, (int)x, (int)(y - offsetHeight), (int)0, (int)width, (int)curHeight, (class_1058)sprite);
            if (++iteration <= 50) continue;
            break;
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
    }

    public void drawBurnBar(class_4587 matrixStack, GuiBase<?> gui, int progress, int maxProgress, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer) {
        if (gui.hideGuiElements()) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        gui.getMinecraft().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 150, 64, 13, 13);
        int j = 13 - (int)((double)progress / (double)maxProgress * 13.0);
        if (j > 0) {
            gui.method_25302(matrixStack, x, y + j, 150, 51 + j, 13, 13 - j);
        }
        if (gui.isPointInRect(x, y, 12, 12, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            list.add(StringUtils.getPercentageText(percentage));
            if (layer == GuiBase.Layer.FOREGROUND) {
                mouseX -= gui.getGuiLeft();
                mouseY -= gui.getGuiTop();
            }
            gui.method_25417(matrixStack, list, mouseX, mouseY);
            RenderSystem.disableLighting();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawOutputSlotBar(class_4587 matrixStack, GuiBase<?> gui, int x, int y, int count) {
        class_310.method_1551().method_1531().method_22813(resourceLocation);
        gui.method_25302(matrixStack, x, y, 150, 122, 3, 26);
        x += 3;
        for (int i = 1; i <= count; ++i) {
            gui.method_25302(matrixStack, x, y, 153, 122, 20, 26);
            x += 20;
        }
        gui.method_25302(matrixStack, x, y, 173, 122, 3, 26);
    }

    protected int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    public static enum ProgressDirection {
        RIGHT(58, 150, 74, 150, 16, 10),
        LEFT(74, 160, 58, 160, 16, 10),
        DOWN(78, 170, 88, 170, 10, 16),
        UP(58, 170, 68, 170, 10, 16);

        public int x;
        public int y;
        public int xActive;
        public int yActive;
        public int width;
        public int height;

        private ProgressDirection(int x, int y, int xActive, int yActive, int width, int height) {
            this.x = x;
            this.y = y;
            this.xActive = xActive;
            this.yActive = yActive;
            this.width = width;
            this.height = height;
        }
    }

    private class TipsListWidget
    extends class_350<TipsListEntry> {
        public TipsListWidget(GuiBase<?> gui, int width, int height, int top, int bottom, int entryHeight, List<class_2561> tips) {
            super(gui.getMinecraft(), width, height, top, bottom, entryHeight);
            for (class_2561 tip : tips) {
                this.method_25321(new TipsListEntry(tip));
            }
        }

        public int method_25322() {
            return 162;
        }

        protected void method_25325(class_4587 matrixStack) {
        }

        private class TipsListEntry
        extends class_350.class_351<TipsListEntry> {
            private class_2561 tip;

            public TipsListEntry(class_2561 tip) {
                this.tip = tip;
            }

            public void method_25343(class_4587 matrixStack, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float delta) {
                class_310.method_1551().field_1772.method_1712((class_5348)this.tip, x, y, width, 0xAAAAAA);
            }
        }
    }
}

