/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.client.gui.builder.RedstoneConfigGui;
import reborncore.client.gui.builder.slot.FluidConfigGui;
import reborncore.client.gui.builder.slot.GuiTab;
import reborncore.client.gui.builder.slot.SlotConfigGui;
import reborncore.client.gui.builder.widget.GuiButtonHologram;
import reborncore.client.gui.guibuilder.GuiBuilder;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.slot.PlayerInventorySlot;
import reborncore.common.blockentity.MachineBaseBlockEntity;

public class GuiBase<T extends class_1703>
extends class_465<T> {
    public static FluidCellProvider fluidCellProvider = fluid -> class_1799.field_8037;
    public static class_1799 wrenchStack = class_1799.field_8037;
    private List<GuiTab.Builder> tabBuilders = (List)class_156.method_654(new ArrayList(), builders -> {
        builders.add(GuiTab.Builder.builder().name("reborncore.gui.tooltip.config_slots").enabled(guiTab -> guiTab.machine().hasSlotConfig()).stack(guiTab -> wrenchStack).draw(SlotConfigGui::draw).click(SlotConfigGui::mouseClicked).mouseReleased(SlotConfigGui::mouseReleased).hideGuiElements().keyPressed((guiBase, keyCode, scanCode, modifiers) -> {
            if (GuiBase.method_25441() && keyCode == 67) {
                SlotConfigGui.copyToClipboard();
                return true;
            }
            if (GuiBase.method_25441() && keyCode == 86) {
                SlotConfigGui.pasteFromClipboard();
                return true;
            }
            if (keyCode == 256 && SlotConfigGui.selectedSlot != -1) {
                SlotConfigGui.reset();
                return true;
            }
            return false;
        }).tips(tips -> {
            tips.add("reborncore.gui.slotconfigtip.slot");
            tips.add("reborncore.gui.slotconfigtip.side1");
            tips.add("reborncore.gui.slotconfigtip.side2");
            tips.add("reborncore.gui.slotconfigtip.side3");
            tips.add("reborncore.gui.slotconfigtip.copy1");
            tips.add("reborncore.gui.slotconfigtip.copy2");
        }));
        builders.add(GuiTab.Builder.builder().name("reborncore.gui.tooltip.config_fluids").enabled(guiTab -> guiTab.machine().showTankConfig()).stack(guiTab -> fluidCellProvider.provide((class_3611)class_3612.field_15908)).draw(FluidConfigGui::draw).click(FluidConfigGui::mouseClicked).mouseReleased(FluidConfigGui::mouseReleased).hideGuiElements());
        builders.add(GuiTab.Builder.builder().name("reborncore.gui.tooltip.config_redstone").stack(guiTab -> new class_1799((class_1935)class_1802.field_8725)).draw(RedstoneConfigGui::draw).click(RedstoneConfigGui::mouseClicked));
    });
    public GuiBuilder builder = new GuiBuilder();
    public class_2586 be;
    @Nullable
    public BuiltScreenHandler builtScreenHandler;
    private int xSize = 176;
    private int ySize = 176;
    private GuiTab selectedTab;
    private List<GuiTab> tabs;
    public boolean upgrades;

    public GuiBase(class_1657 player, class_2586 blockEntity, T screenHandler) {
        super(screenHandler, player.field_7514, (class_2561)new class_2585(class_1074.method_4662((String)blockEntity.method_11010().method_26204().method_9539(), (Object[])new Object[0])));
        this.be = blockEntity;
        this.builtScreenHandler = (BuiltScreenHandler)screenHandler;
        this.selectedTab = null;
        this.populateSlots();
    }

    private void populateSlots() {
        this.tabs = this.tabBuilders.stream().map(builder -> builder.build(this.getMachine(), this)).filter(GuiTab::enabled).collect(Collectors.toList());
    }

    public int getScreenWidth() {
        return this.field_2792;
    }

    public void drawSlot(class_4587 matrixStack, int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_2776;
            y += this.field_2800;
        }
        this.builder.drawSlot(matrixStack, (class_437)this, x - 1, y - 1);
    }

    public void drawOutputSlotBar(class_4587 matrixStack, int x, int y, int count, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_2776;
            y += this.field_2800;
        }
        this.builder.drawOutputSlotBar(matrixStack, this, x - 4, y - 4, count);
    }

    public void drawArmourSlots(class_4587 matrixStack, int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_2776;
            y += this.field_2800;
        }
        this.builder.drawSlot(matrixStack, (class_437)this, x - 1, y - 1);
        this.builder.drawSlot(matrixStack, (class_437)this, x - 1, y - 1 + 18);
        this.builder.drawSlot(matrixStack, (class_437)this, x - 1, y - 1 + 18 + 18);
        this.builder.drawSlot(matrixStack, (class_437)this, x - 1, y - 1 + 18 + 18 + 18);
    }

    public void drawOutputSlot(class_4587 matrixStack, int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.field_2776;
            y += this.field_2800;
        }
        this.builder.drawOutputSlot(matrixStack, this, x - 5, y - 5);
    }

    public void method_25426() {
        super.method_25426();
        if (this.isConfigEnabled()) {
            SlotConfigGui.init(this);
        }
        if (this.isConfigEnabled() && this.getMachine().getTank() != null && this.getMachine().showTankConfig()) {
            FluidConfigGui.init(this);
        }
    }

    protected void method_2389(class_4587 matrixStack, float lastFrameDuration, int mouseX, int mouseY) {
        IUpgradeable upgradeable;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.method_25420(matrixStack);
        boolean drawPlayerSlots = this.selectedTab == null && this.drawPlayerSlots();
        this.updateSlotDraw(drawPlayerSlots);
        this.builder.drawDefaultBackground(matrixStack, (class_437)this, this.field_2776, this.field_2800, this.xSize, this.ySize);
        if (drawPlayerSlots) {
            this.builder.drawPlayerSlots(matrixStack, (class_437)this, this.field_2776 + this.field_2792 / 2, this.field_2800 + 93, true);
        }
        if (this.tryAddUpgrades() && this.be instanceof IUpgradeable && (upgradeable = (IUpgradeable)this.be).canBeUpgraded()) {
            this.builder.drawUpgrades(matrixStack, this, this.field_2776 - 24, this.field_2800 + 6);
            this.upgrades = true;
        }
        int offset = this.upgrades ? 86 : 6;
        for (GuiTab slot : this.tabs) {
            if (!slot.enabled()) continue;
            this.builder.drawSlotTab(matrixStack, this, this.field_2776 - 24, this.field_2800 + offset, slot.stack());
            offset += 24;
        }
        GuiBase gui = this;
        this.getTab().ifPresent(guiTab -> this.builder.drawSlotConfigTips(matrixStack, gui, this.field_2776 + this.field_2792 / 2, this.field_2800 + 93, mouseX, mouseY, (GuiTab)guiTab));
    }

    private void updateSlotDraw(boolean doDraw) {
        if (this.builtScreenHandler == null) {
            return;
        }
        for (class_1735 slot : this.builtScreenHandler.field_7761) {
            if (!(slot instanceof PlayerInventorySlot)) continue;
            ((PlayerInventorySlot)slot).doDraw = doDraw;
        }
    }

    public boolean drawPlayerSlots() {
        return true;
    }

    public boolean tryAddUpgrades() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    protected void method_2388(class_4587 matrixStack, int mouseX, int mouseY) {
        this.drawTitle(matrixStack);
        this.getTab().ifPresent(guiTab -> guiTab.draw(matrixStack, mouseX, mouseY));
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.method_2380(matrixStack, mouseX, mouseY);
    }

    protected void method_2380(class_4587 matrixStack, int mouseX, int mouseY) {
        if (this.method_2378(-25, 6, 24, 80, mouseX, mouseY) && this.upgrades) {
            ArrayList<class_2588> list = new ArrayList<class_2588>();
            list.add(new class_2588("reborncore.gui.tooltip.upgrades"));
            this.method_25417(matrixStack, list, mouseX, mouseY);
            RenderSystem.disableLighting();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int offset = this.upgrades ? 82 : 0;
        for (GuiTab tab : this.tabs) {
            if (this.method_2378(-26, 6 + offset, 24, 23, mouseX, mouseY)) {
                this.method_25417(matrixStack, Collections.singletonList(new class_2588(tab.name())), mouseX, mouseY);
                RenderSystem.disableLighting();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            offset += 24;
        }
        for (class_339 abstractButtonWidget : this.field_22791) {
            if (!abstractButtonWidget.method_25367()) continue;
            abstractButtonWidget.method_25352(matrixStack, mouseX, mouseY);
            break;
        }
        super.method_2380(matrixStack, mouseX, mouseY);
    }

    protected void drawTitle(class_4587 matrixStack) {
        this.drawCentredText(matrixStack, (class_2561)new class_2588(this.be.method_11010().method_26204().method_9539()), 6, 0x404040, Layer.FOREGROUND);
    }

    public void drawCentredText(class_4587 matrixStack, class_2561 text, int y, int colour, Layer layer) {
        this.drawText(matrixStack, text, this.field_2792 / 2 - this.getTextRenderer().method_27525((class_5348)text) / 2, y, colour, layer);
    }

    protected void drawCentredText(class_4587 matrixStack, class_2561 text, int y, int colour, int modifier, Layer layer) {
        this.drawText(matrixStack, text, this.field_2792 / 2 - this.getTextRenderer().method_27525((class_5348)text) / 2 + modifier, y, colour, layer);
    }

    public void drawText(class_4587 matrixStack, class_2561 text, int x, int y, int colour, Layer layer) {
        int factorX = 0;
        int factorY = 0;
        if (layer == Layer.BACKGROUND) {
            factorX = this.field_2776;
            factorY = this.field_2800;
        }
        this.getTextRenderer().method_27528(matrixStack, (class_5348)text, (float)(x + factorX), (float)(y + factorY), colour);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public GuiButtonHologram addHologramButton(int x, int y, int id, Layer layer) {
        GuiButtonHologram buttonHologram = new GuiButtonHologram(x + this.field_2776, y + this.field_2800, this, layer, var1 -> {});
        this.method_25411((class_339)buttonHologram);
        return buttonHologram;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.getTab().map(guiTab -> guiTab.click(mouseX, mouseY, mouseButton)).orElse(false).booleanValue()) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        int offset = 0;
        if (!this.upgrades) {
            offset = 80;
        }
        for (GuiTab tab : this.tabs) {
            if (this.method_2378(-26, 84 - offset, 30, 23, mouseX, mouseY)) {
                if (this.selectedTab == tab) {
                    this.closeSelectedTab();
                } else {
                    this.selectedTab = tab;
                }
                SlotConfigGui.reset();
                break;
            }
            offset -= 24;
        }
        if (this.getTab().map(guiTab -> guiTab.mouseReleased(mouseX, mouseY, state)).orElse(false).booleanValue()) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, state);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.getTab().map(guiTab -> guiTab.keyPress(keyCode, scanCode, modifiers)).orElse(false).booleanValue()) {
            return true;
        }
        if (this.selectedTab != null && keyCode == 256) {
            this.closeSelectedTab();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.closeSelectedTab();
        super.method_25419();
    }

    @Nullable
    public MachineBaseBlockEntity getMachine() {
        return (MachineBaseBlockEntity)this.be;
    }

    public boolean isPointInRect(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        return super.method_2378(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean isConfigEnabled() {
        return this.be instanceof MachineBaseBlockEntity && this.builtScreenHandler != null;
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }

    public class_310 getMinecraft() {
        if (this.field_22787 == null) {
            throw new NullPointerException("Minecraft client is null.");
        }
        return this.field_22787;
    }

    public class_327 getTextRenderer() {
        return this.field_22793;
    }

    public Optional<GuiTab> getTab() {
        if (!this.isConfigEnabled()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.selectedTab);
    }

    public boolean isTabOpen() {
        return this.selectedTab != null;
    }

    public boolean hideGuiElements() {
        return this.selectedTab != null && this.selectedTab.hideGuiElements();
    }

    public void closeSelectedTab() {
        this.selectedTab = null;
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int mouseButton) {
        return super.method_2381(mouseX + 40.0, mouseY, left + 40, top, mouseButton);
    }

    public List<GuiTab> getTabs() {
        return this.tabs;
    }

    public static interface FluidCellProvider {
        public class_1799 provide(class_3611 var1);
    }

    public static enum Layer {
        BACKGROUND,
        FOREGROUND;

    }
}

