/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.network;

import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2792;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class NetworkManager {


	public static class_2596<class_2792> createServerBoundPacket(class_2960 identifier, Consumer<ExtendedPacketBuffer> packetBufferConsumer) {
		class_2540 buf = new class_2540(Unpooled.buffer());
		packetBufferConsumer.accept(new ExtendedPacketBuffer(buf));
		return new class_2817(identifier, buf);
	}

	public static void registerServerBoundHandler(class_2960 identifier, BiConsumer<ExtendedPacketBuffer, PacketContext> consumer){
		ServerSidePacketRegistry.INSTANCE.register(identifier, (packetContext, packetByteBuf) -> consumer.accept(new ExtendedPacketBuffer(packetByteBuf), packetContext));
	}

	public static class_2596<class_2602> createClientBoundPacket(class_2960 identifier, Consumer<ExtendedPacketBuffer> packetBufferConsumer) {
		class_2540 buf = new class_2540(Unpooled.buffer());
		packetBufferConsumer.accept(new ExtendedPacketBuffer(buf));
		return new class_2658(identifier, buf);
	}
	public static void registerClientBoundHandler(class_2960 identifier, BiConsumer<ExtendedPacketBuffer, PacketContext> consumer){
		ClientSidePacketRegistry.INSTANCE.register(identifier, (packetContext, packetByteBuf) -> consumer.accept(new ExtendedPacketBuffer(packetByteBuf), packetContext));
	}


	public static void sendToServer(class_2596<?> packet) {
		class_310.method_1551().method_1562().method_2883(packet);
	}

	public static void sendToAll(class_2596<?> packet, MinecraftServer server) {
		server.method_3760().method_14581(packet);
	}

	public static void sendToPlayer(class_2596<?> packet, class_3222 serverPlayerEntity) {
		serverPlayerEntity.field_13987.method_14364(packet);
	}

	public static void sendToWorld(class_2596<?> packet, class_3218 world) {
		world.method_18456().forEach(serverPlayerEntity -> sendToPlayer(packet, serverPlayerEntity));
	}


	public static void sendToTracking(class_2596<?> packet, class_3218 world, class_2338 pos) {
		//TODO fix this to be better
		sendToWorld(packet, world);

	}

	public static void sendToTracking(class_2596<?> packet, class_2586 blockEntity) {
		sendToTracking(packet, (class_3218) blockEntity.method_10997(), blockEntity.method_11016());
	}


}
