/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.network;

import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.chunkloading.ChunkLoaderManager;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;

public class ClientBoundPackets {

	public static class_2596<class_2602> createCustomDescriptionPacket(class_2586 blockEntity) {
		return createCustomDescriptionPacket(blockEntity.method_11016(), blockEntity.method_11007(new class_2487()));
	}

	public static class_2596<class_2602> createCustomDescriptionPacket(class_2338 blockPos, class_2487 nbt) {
		return NetworkManager.createClientBoundPacket(new class_2960("reborncore", "custom_description"), packetBuffer -> {
			packetBuffer.method_10807(blockPos);
			packetBuffer.method_10794(nbt);
		});
	}

	public static class_2596<class_2602> createPacketFluidConfigSync(class_2338 pos, FluidConfiguration fluidConfiguration) {
		return NetworkManager.createClientBoundPacket(new class_2960("reborncore", "fluid_config_sync"), packetBuffer -> {
			packetBuffer.method_10807(pos);
			packetBuffer.method_10794(fluidConfiguration.write());
		});
	}

	public static class_2596<class_2602> createPacketSlotSync(class_2338 pos, SlotConfiguration slotConfig) {
		return NetworkManager.createClientBoundPacket(new class_2960("reborncore", "slot_sync"), packetBuffer -> {
			packetBuffer.method_10807(pos);
			packetBuffer.method_10794(slotConfig.write());
		});
	}

	public static class_2596<class_2602> createPacketSendObject(int id, Object value, class_1703 screenHandler) {
		return NetworkManager.createClientBoundPacket(new class_2960("reborncore", "send_object"), packetBuffer -> {
			packetBuffer.writeInt(id);
			packetBuffer.writeObject(value);
			packetBuffer.writeInt(screenHandler.getClass().getName().length());
			packetBuffer.method_10814(screenHandler.getClass().getName());
		});
	}

	public static class_2596<class_2602> createPacketSyncLoadedChunks(List<ChunkLoaderManager.LoadedChunk> chunks){
		return NetworkManager.createClientBoundPacket(new class_2960("reborncore", "sync_chunks"), extendedPacketBuffer -> {
			extendedPacketBuffer.writeCodec(ChunkLoaderManager.CODEC, chunks);
		});
	}

}
