/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.fluid;

import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;

public abstract class RebornFluid extends class_3609 {

	private final boolean still;

	private final FluidSettings fluidSettings;
	private final Supplier<RebornFluidBlock> fluidBlockSupplier;
	private final Supplier<RebornBucketItem> bucketItemSuppler;
	private final Supplier<RebornFluid> flowingSuppler;
	private final Supplier<RebornFluid> stillSuppler;

	public RebornFluid(boolean still, FluidSettings fluidSettings, Supplier<RebornFluidBlock> fluidBlockSupplier, Supplier<RebornBucketItem> bucketItemSuppler, Supplier<RebornFluid> flowingSuppler, Supplier<RebornFluid> stillSuppler) {
		this.still = still;
		this.fluidSettings = fluidSettings;
		this.fluidBlockSupplier = fluidBlockSupplier;
		this.bucketItemSuppler = bucketItemSuppler;
		this.flowingSuppler = flowingSuppler;
		this.stillSuppler = stillSuppler;
	}

	public FluidSettings getFluidSettings() {
		return fluidSettings;
	}

	@Override
	public RebornFluid getFlowing() {
		return flowingSuppler.get();
	}

	@Override
	public RebornFluid getStill() {
		return stillSuppler.get();
	}

	@Override
	protected boolean method_15737() {
		return false;
	}

	@Override
	public boolean method_15793(class_3610 fluidState) {
		return still;
	}

	@Override
	protected void method_15730(class_1936 world, class_2338 pos, class_2680 state) {

	}

	@Override
	protected int method_15733(class_4538 world) {
		return 4;
	}

	@Override
	protected int method_15739(class_4538 world) {
		return 1;
	}

	@Override
	public class_1792 method_15774() {
		return bucketItemSuppler.get();
	}

	@Override
	protected boolean method_15777(class_3610 fluidState, class_1922 blockView, class_2338 blockPos, class_3611 fluid, class_2350 direction) {
		return false;
	}

	@Override
	public boolean method_15780(class_3611 fluid) {
		return getFlowing() == fluid || getStill() == fluid;
	}

	@Override
	public int method_15789(class_4538 world) {
		return 10;
	}

	@Override
	protected float method_15784() {
		return 100F;
	}

	@Override
	protected class_2680 method_15790(class_3610 fluidState) {
		return fluidBlockSupplier.get().method_9564().method_11657(class_2404.field_11278, method_15741(fluidState));
	}

	@Override
	public int method_15779(class_3610 fluidState) {
		return still ? 8 : fluidState.method_11654(field_15900);
	}

	@Override
	protected void method_15775(class_2689.class_2690<class_3611, class_3610> stateBuilder) {
		super.method_15775(stateBuilder);
		if(!still){
			stateBuilder.method_11667(field_15900);
		}
	}

}
