/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import reborncore.common.util.DefaultedListCollector;
import reborncore.common.util.serialization.SerializationUtil;
import reborncore.mixin.common.AccessorRecipeManager;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class RecipeUtils {
	@SuppressWarnings("unchecked")
	public static <T extends RebornRecipe> List<T> getRecipes(class_1937 world, RebornRecipeType<?> type){
		AccessorRecipeManager accessorRecipeManager = (AccessorRecipeManager) world.method_8433();
		//noinspection unchecked
		return new ArrayList<>(accessorRecipeManager.getAll(type).values());
	}

	public static class_2371<class_1799> deserializeItems(JsonElement jsonObject){
		if(jsonObject.isJsonArray()){
			return SerializationUtil.stream(jsonObject.getAsJsonArray()).map(entry -> deserializeItem(entry.getAsJsonObject())).collect(DefaultedListCollector.toList());
		} else {
			return class_2371.method_10212(deserializeItem(jsonObject.getAsJsonObject()));
		}
	}

	private static class_1799 deserializeItem(JsonObject jsonObject){
		class_2960 resourceLocation = new class_2960(class_3518.method_15265(jsonObject, "item"));
		class_1792 item = class_2378.field_11142.method_10223(resourceLocation);
		if(item == class_1802.field_8162){
			throw new IllegalStateException(resourceLocation + " did not exist");
		}
		int count = 1;
		if(jsonObject.has("count")){
			count = class_3518.method_15260(jsonObject, "count");
		}
		class_1799 stack = new class_1799(item, count);
		if(jsonObject.has("nbt")){
			class_2487 tag = (class_2487) Dynamic.convert(JsonOps.INSTANCE, class_2509.field_11560, jsonObject.get("nbt"));
			stack.method_7980(tag);
		}
		return stack;
	}

}
