/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client;

import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_922;

/**
 * Created by Mark on 27/11/2016.
 */
public class HolidayRenderManager {

	private static final ModelSantaHat santaHat = new ModelSantaHat();
	private static final class_2960 TEXTURE = new class_2960("reborncore", "textures/models/santa_hat.png");

	public static class LayerRender extends class_3887<class_742, class_591<class_742>> {

		public LayerRender(class_3883<class_742, class_591<class_742>> featureRendererContext_1) {
			super(featureRendererContext_1);
		}

		@Override
		public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_742 player, float f, float g, float tickDelta, float h, float j, float k) {
			class_310.method_1551().method_1531().method_22813(TEXTURE);
			class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23572(TEXTURE));
			matrixStack.method_22903();

			float yaw = player.field_5982 + (player.field_6031 - player.field_5982) * tickDelta - (player.field_6220 + (player.field_6283 - player.field_6220) * tickDelta);
			float pitch = player.field_6004 + (player.field_5965 - player.field_6004) * tickDelta;

			matrixStack.method_22907(class_1160.field_20705.method_23214(yaw));
			matrixStack.method_22907(class_1160.field_20703.method_23214(pitch));
			santaHat.method_2828(matrixStack, vertexConsumer, i, class_922.method_23622(player, 0.0F), 1F, 1F, 1F, 1F);
			matrixStack.method_22909();
		}
	}

}
