/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mixin.common;

import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_29;
import net.minecraft.class_31;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import reborncore.common.world.DataAttachment;
import reborncore.common.world.DataAttachmentProvider;

@Mixin(value={class_29.class})
public class MixinWorldSaveHandler
implements DataAttachmentProvider {
    @Shadow
    @Final
    private File field_145;
    @Unique
    private final HashMap<Class<? extends DataAttachment>, DataAttachment> attachmentMap = new HashMap();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(File file, String worldName, @Nullable MinecraftServer minecraftServer, DataFixer dataFixer, CallbackInfo info) {
        DataAttachment.REGISTRY.lock();
        for (Map.Entry<Class<? extends DataAttachment>, Supplier<? extends DataAttachment>> entry : DataAttachment.REGISTRY.getAllDataAttachments().entrySet()) {
            this.attachmentMap.put(entry.getKey(), entry.getValue().get());
        }
    }

    @Inject(method={"saveWorld(Lnet/minecraft/world/level/LevelProperties;Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void saveWorld(class_31 levelProperties, class_2487 compoundTag, CallbackInfo info) {
        class_2487 tag = new class_2487();
        for (Map.Entry<Class<? extends DataAttachment>, DataAttachment> entry : this.attachmentMap.entrySet()) {
            tag.method_10566(entry.getKey().getName(), (class_2520)entry.getValue().write());
        }
        try {
            FileOutputStream fio = new FileOutputStream(this.reborncore_getFile());
            class_2507.method_10634((class_2487)tag, (OutputStream)fio);
            fio.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save reborncore world data!", e);
        }
    }

    @Inject(method={"readProperties"}, at={@At(value="HEAD")})
    private void readWorldProperties(CallbackInfoReturnable<class_31> callbackInfo) throws IOException {
        File file = this.reborncore_getFile();
        if (file.exists()) {
            try {
                FileInputStream fio = new FileInputStream(file);
                class_2487 tag = class_2507.method_10629((InputStream)fio);
                fio.close();
                for (Map.Entry<Class<? extends DataAttachment>, DataAttachment> entry : this.attachmentMap.entrySet()) {
                    String name = entry.getKey().getName();
                    if (!tag.method_10545(name)) continue;
                    entry.getValue().read(tag.method_10562(name));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read reborncore world data!", e);
            }
        }
    }

    @Unique
    private File reborncore_getFile() {
        return new File(new File(this.field_145, "data"), "reborncore.dat");
    }

    @Override
    public <T extends DataAttachment> T getAttachment(Class<T> identifier) {
        return (T)this.attachmentMap.get(identifier);
    }
}

