/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.world;

import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import reborncore.common.world.DataAttachment;

public class DataAttachmentRegistry {
    private static HashMap<Class<? extends DataAttachment>, Supplier<? extends DataAttachment>> dataAttachments = new HashMap();
    private static boolean locked = false;

    public <T extends DataAttachment> void register(Class<T> clazz, Supplier<T> supplier) {
        Validate.isTrue((!locked ? 1 : 0) != 0, (String)"Data attachment registry is locked!", (Object[])new Object[0]);
        if (dataAttachments.containsKey(clazz)) {
            throw new UnsupportedOperationException("Data attachment already registered for " + clazz.getName());
        }
        dataAttachments.put(clazz, supplier);
    }

    public HashMap<Class<? extends DataAttachment>, Supplier<? extends DataAttachment>> getAllDataAttachments() {
        Validate.isTrue((boolean)locked, (String)"Data attachment registry is not locked!", (Object[])new Object[0]);
        return dataAttachments;
    }

    public void lock() {
        locked = true;
    }
}

