/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;

public class PowerSystem {
    public static File selectedFile;
    private static EnergySystem selectedSystem;
    private static final char[] magnitude;

    public static String getLocaliszedPower(double eu) {
        return PowerSystem.getLocaliszedPower((int)eu);
    }

    public static String getLocaliszedPowerNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerNoSuffix((int)eu);
    }

    public static String getLocaliszedPowerFormatted(double eu) {
        return PowerSystem.getLocaliszedPowerFormatted((int)eu);
    }

    public static String getLocaliszedPowerFormattedNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)eu);
    }

    public static String getLocaliszedPower(int eu) {
        return PowerSystem.getRoundedString(eu, EnergySystem.EU.abbreviation);
    }

    public static String getLocaliszedPowerNoSuffix(int eu) {
        return PowerSystem.getRoundedString(eu, "");
    }

    public static String getLocaliszedPowerFormatted(int eu) {
        return PowerSystem.getRoundedString(eu, EnergySystem.EU.abbreviation);
    }

    public static String getLocaliszedPowerFormattedNoSuffix(int eu) {
        return PowerSystem.getRoundedString(eu, "", true);
    }

    private static String getRoundedString(double value, String units) {
        return PowerSystem.getRoundedString(value, units, false);
    }

    private static String getRoundedString(double euValue, String units, boolean doFormat) {
        String ret = "";
        double value = 0.0;
        int i = 0;
        boolean showMagnitude = true;
        if (euValue < 0.0) {
            ret = "-";
            euValue = -euValue;
        }
        if (euValue < 1000.0) {
            doFormat = false;
            showMagnitude = false;
            value = euValue;
        } else if (euValue >= 1000.0) {
            i = 0;
            while (true) {
                if (euValue < 10000.0 && euValue % 1000.0 >= 100.0) {
                    value = Math.floor(euValue / 1000.0);
                    value += (double)((float)euValue % 1000.0f / 1000.0f);
                    break;
                }
                if ((euValue /= 1000.0) < 1000.0) {
                    value = euValue;
                    break;
                }
                ++i;
            }
        }
        String strValue = String.valueOf(value);
        strValue = strValue.substring(0, strValue.lastIndexOf(46) + 2);
        ret = ret + strValue;
        if (showMagnitude) {
            ret = ret + magnitude[i];
        }
        if (units != "") {
            ret = ret + " " + units;
        }
        return ret;
    }

    public static EnergySystem getDisplayPower() {
        if (!PowerSystem.selectedSystem.enabled.get().booleanValue()) {
            PowerSystem.bumpPowerConfig();
        }
        return selectedSystem;
    }

    public static void bumpPowerConfig() {
        int value = selectedSystem.ordinal() + 1;
        if (value == EnergySystem.values().length) {
            value = 0;
        }
        selectedSystem = EnergySystem.values()[value];
        PowerSystem.writeFile();
    }

    public static void readFile() {
        if (!selectedFile.exists()) {
            PowerSystem.writeFile();
        }
        if (selectedFile.exists()) {
            try {
                String value = FileUtils.readFileToString((File)selectedFile, (Charset)StandardCharsets.UTF_8);
                selectedSystem = Arrays.stream(EnergySystem.values()).filter(energySystem -> energySystem.abbreviation.equalsIgnoreCase(value)).findFirst().orElse(EnergySystem.values()[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeFile() {
        try {
            FileUtils.write((File)selectedFile, (CharSequence)PowerSystem.selectedSystem.abbreviation, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PowerSystem.readFile();
    }

    static {
        selectedSystem = EnergySystem.values()[0];
        magnitude = new char[]{'k', 'M', 'G', 'T'};
    }

    public static enum EnergySystem {
        EU(-8387072, "E", 141, 151, -10027008);

        public int colour;
        public int altColour;
        public String abbreviation;
        public int xBar;
        public int yBar;
        public Supplier<Boolean> enabled = () -> true;

        private EnergySystem(int colour, String abbreviation, int xBar, int yBar, int altColour) {
            this.colour = colour;
            this.abbreviation = abbreviation;
            this.xBar = xBar;
            this.yBar = yBar;
            this.altColour = altColour;
        }
    }
}

