/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import reborncore.api.IListInfoProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergySide;
import team.reborn.energy.EnergyStorage;
import team.reborn.energy.EnergyTier;

public abstract class PowerAcceptorBlockEntity
extends MachineBaseBlockEntity
implements EnergyStorage,
IListInfoProvider {
    private EnergyTier blockEntityPowerTier;
    private double energy;
    public double extraPowerStorage;
    public double extraPowerInput;
    public int extraTier;
    public double powerChange;
    public double powerLastTick;
    public boolean checkOverfill = true;
    public int maxPacketsPerTick = 1;

    public PowerAcceptorBlockEntity(class_2591<?> blockEntityType) {
        super(blockEntityType);
        this.checkTier();
    }

    public void checkTier() {
        this.blockEntityPowerTier = this.getMaxInput(EnergySide.UNKNOWN) == 0.0 ? PowerAcceptorBlockEntity.getTier((int)this.getBaseMaxOutput()) : PowerAcceptorBlockEntity.getTier((int)this.getBaseMaxInput());
    }

    public static EnergyTier getTier(int power) {
        for (EnergyTier tier : EnergyTier.values()) {
            if (tier.getMaxInput() < power) continue;
            return tier;
        }
        return EnergyTier.INFINITE;
    }

    public void setExtraPowerStorage(double extraPowerStorage) {
        this.extraPowerStorage = extraPowerStorage;
    }

    public void setMaxPacketsPerTick(int maxPacketsPerTick) {
        this.maxPacketsPerTick = maxPacketsPerTick;
    }

    public double getFreeSpace() {
        return this.getMaxPower() - this.getEnergy();
    }

    public void charge(int slot) {
        if (this.field_11863.field_9236) {
            return;
        }
        double chargeEnergy = Math.min(this.getFreeSpace(), this.getMaxInput(EnergySide.UNKNOWN));
        if (chargeEnergy <= 0.0) {
            return;
        }
        if (!this.getOptionalInventory().isPresent()) {
            return;
        }
        class_1799 batteryStack = this.getOptionalInventory().get().method_5438(slot);
        if (batteryStack.method_7960()) {
            return;
        }
        if (Energy.valid((Object)batteryStack)) {
            Energy.of((Object)batteryStack).into(Energy.of((Object)this)).move();
        }
    }

    public void discharge(int slot) {
        if (this.field_11863.field_9236) {
            return;
        }
        class_1799 batteryStack = this.getOptionalInventory().get().method_5438(slot);
        if (batteryStack.method_7960()) {
            return;
        }
        if (Energy.valid((Object)batteryStack)) {
            Energy.of((Object)this).into(Energy.of((Object)batteryStack)).move();
        }
    }

    public int getEnergyScaled(int scale) {
        return (int)(this.getEnergy() * (double)scale / this.getMaxPower());
    }

    public boolean shouldHanldeEnergyNBT() {
        return true;
    }

    public boolean handleTierWithPower() {
        return true;
    }

    public double getPowerChange() {
        return this.powerChange;
    }

    public void setPowerChange(double powerChange) {
        this.powerChange = powerChange;
    }

    @Override
    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.getEnergy() > 0.0 && this.isActive(RedstoneConfiguration.POWER_IO)) {
            for (class_2350 side : class_2350.values()) {
                class_2586 blockEntity = this.method_10997().method_8321(this.method_11016().method_10093(side));
                if (blockEntity == null || !Energy.valid((Object)blockEntity)) continue;
                Energy.of((Object)this).side(EnergySide.fromMinecraft((Enum)side)).into(Energy.of((Object)blockEntity).side(EnergySide.fromMinecraft((Enum)side.method_10153()))).move();
            }
        }
        this.powerChange = this.getEnergy() - this.powerLastTick;
        this.powerLastTick = this.getEnergy();
    }

    @Override
    public void method_11014(class_2680 blockState, class_2487 tag) {
        super.method_11014(blockState, tag);
        class_2487 data = tag.method_10562("PowerAcceptor");
        if (this.shouldHanldeEnergyNBT()) {
            this.setEnergy(data.method_10574("energy"));
        }
    }

    @Override
    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2487 data = new class_2487();
        data.method_10549("energy", this.getEnergy());
        tag.method_10566("PowerAcceptor", (class_2520)data);
        return tag;
    }

    @Override
    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraPowerStorage = 0.0;
        this.extraTier = 0;
        this.extraPowerInput = 0.0;
    }

    public abstract double getBaseMaxPower();

    public abstract double getBaseMaxOutput();

    public abstract double getBaseMaxInput();

    public double getEnergy() {
        return this.getStored(EnergySide.UNKNOWN);
    }

    public double getStored(EnergySide face) {
        return this.energy;
    }

    public void setStored(double amount) {
        this.energy = amount;
        if (this.checkOverfill) {
            this.energy = Math.max(Math.min(this.energy, this.getMaxPower()), 0.0);
        }
        this.method_5431();
    }

    public void setEnergy(double energy) {
        this.setStored(energy);
    }

    public double addEnergy(double energy) {
        return this.addEnergy(energy, false);
    }

    public double addEnergy(double energy, boolean simulate) {
        double energyReceived = Math.min(this.getMaxPower(), Math.min(this.getFreeSpace(), energy));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + energyReceived);
        }
        return energyReceived;
    }

    public boolean canUseEnergy(double input) {
        return input <= this.energy;
    }

    public double useEnergy(double energy) {
        return this.useEnergy(energy, false);
    }

    public double useEnergy(double extract, boolean simulate) {
        if (extract > this.energy) {
            extract = this.energy;
        }
        if (!simulate) {
            this.setEnergy(this.energy - extract);
        }
        return extract;
    }

    public boolean canAddEnergy(double energyIn) {
        return this.getEnergy() + energyIn <= this.getMaxPower();
    }

    public double getMaxPower() {
        return this.getBaseMaxPower() + this.extraPowerStorage;
    }

    public double getMaxStoredPower() {
        return this.getMaxPower();
    }

    public boolean canAcceptEnergy(class_2350 direction) {
        return true;
    }

    public boolean canProvideEnergy(class_2350 direction) {
        return true;
    }

    public double getMaxOutput(EnergySide face) {
        if (!this.isActive(RedstoneConfiguration.POWER_IO)) {
            return 0.0;
        }
        if (!this.canProvideEnergy(PowerAcceptorBlockEntity.fromSide(face))) {
            return 0.0;
        }
        double maxOutput = 0.0;
        maxOutput = this.extraTier > 0 ? (double)this.getTier().getMaxOutput() : this.getBaseMaxOutput();
        return maxOutput;
    }

    public double getMaxInput(EnergySide face) {
        if (!this.isActive(RedstoneConfiguration.POWER_IO)) {
            return 0.0;
        }
        if (!this.canAcceptEnergy(PowerAcceptorBlockEntity.fromSide(face))) {
            return 0.0;
        }
        double maxInput = 0.0;
        maxInput = this.extraTier > 0 ? (double)this.getTier().getMaxInput() : this.getBaseMaxInput();
        return maxInput + this.extraPowerInput;
    }

    public static class_2350 fromSide(EnergySide side) {
        if (side == EnergySide.UNKNOWN) {
            return null;
        }
        return class_2350.values()[side.ordinal()];
    }

    public EnergyTier getPushingTier() {
        return this.getTier();
    }

    public EnergyTier getTier() {
        if (this.blockEntityPowerTier == null) {
            this.checkTier();
        }
        if (this.extraTier > 0) {
            for (EnergyTier enumTier : EnergyTier.values()) {
                if (enumTier.ordinal() != this.blockEntityPowerTier.ordinal() + this.extraTier) continue;
                return this.blockEntityPowerTier;
            }
            return EnergyTier.INFINITE;
        }
        return this.blockEntityPowerTier;
    }

    @Override
    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        info.add((class_2561)new class_2585(class_124.field_1080 + StringUtils.t("reborncore.tooltip.energy.maxEnergy") + ": " + class_124.field_1065 + PowerSystem.getLocaliszedPowerFormatted(this.getMaxPower())));
        if (this.getMaxInput(EnergySide.UNKNOWN) != 0.0) {
            info.add((class_2561)new class_2585(class_124.field_1080 + StringUtils.t("reborncore.tooltip.energy.inputRate") + ": " + class_124.field_1065 + PowerSystem.getLocaliszedPowerFormatted(this.getMaxInput(EnergySide.UNKNOWN))));
        }
        if (this.getMaxOutput(EnergySide.UNKNOWN) <= 0.0) {
            info.add((class_2561)new class_2585(class_124.field_1080 + StringUtils.t("reborncore.tooltip.energy.outputRate") + ": " + class_124.field_1065 + PowerSystem.getLocaliszedPowerFormatted(this.getMaxOutput(EnergySide.UNKNOWN))));
        }
        info.add((class_2561)new class_2585(class_124.field_1080 + StringUtils.t("reborncore.tooltip.energy.tier") + ": " + class_124.field_1065 + StringUtils.toFirstCapitalAllLowercase(this.getTier().toString())));
        if (isReal) {
            info.add((class_2561)new class_2585(class_124.field_1080 + StringUtils.t("reborncore.tooltip.energy.change") + ": " + class_124.field_1065 + PowerSystem.getLocaliszedPowerFormatted(this.getPowerChange()) + "/t"));
        }
        if (hasData) {
            info.add((class_2561)new class_2585(class_124.field_1080 + StringUtils.t("reborncore.tooltip.energy") + ": " + class_124.field_1065 + PowerSystem.getLocaliszedPowerFormatted(this.energy)));
        }
        super.addInfo(info, isReal, hasData);
    }

    public static int calculateComparatorOutputFromEnergy(@Nullable class_2586 blockEntity) {
        if (blockEntity instanceof PowerAcceptorBlockEntity) {
            PowerAcceptorBlockEntity storage = (PowerAcceptorBlockEntity)blockEntity;
            return class_3532.method_15384((double)(storage.getEnergy() * 15.0 / storage.getMaxPower()));
        }
        return 0;
    }
}

