/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.apache.commons.lang3.Validate;
import reborncore.common.crafting.ingredient.IngredientManager;
import reborncore.common.crafting.ingredient.RebornIngredient;

public class StackIngredient
extends RebornIngredient {
    private final List<class_1799> stacks;
    private final Optional<Integer> count;
    private final Optional<class_2487> tag;
    private final boolean requireEmptyTag;

    public StackIngredient(List<class_1799> stacks, Optional<Integer> count, Optional<class_2487> tag, boolean requireEmptyTag) {
        super(IngredientManager.STACK_RECIPE_TYPE);
        this.stacks = stacks;
        this.count = count;
        this.tag = tag;
        this.requireEmptyTag = requireEmptyTag;
        Validate.isTrue((stacks.size() == 1 ? 1 : 0) != 0, (String)"stack size must 1", (Object[])new Object[0]);
    }

    public static RebornIngredient deserialize(JsonObject json) {
        if (!json.has("item")) {
            System.out.println("nope");
        }
        class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)json, (String)"item"));
        class_1792 item = (class_1792)class_2378.field_11142.method_17966(identifier).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + identifier + "'"));
        Optional<Integer> stackSize = Optional.empty();
        if (json.has("count")) {
            stackSize = Optional.of(class_3518.method_15260((JsonObject)json, (String)"count"));
        }
        Optional<class_2487> tag = Optional.empty();
        boolean requireEmptyTag = false;
        if (json.has("nbt")) {
            if (!json.get("nbt").isJsonObject()) {
                if (json.get("nbt").getAsString().equals("empty")) {
                    requireEmptyTag = true;
                }
            } else {
                tag = Optional.of((class_2487)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)class_2509.field_11560, (Object)json.get("nbt")));
            }
        }
        return new StackIngredient(Collections.singletonList(new class_1799((class_1935)item)), stackSize, tag, requireEmptyTag);
    }

    @Override
    public boolean test(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        if (this.stacks.stream().noneMatch(recipeStack -> recipeStack.method_7909() == itemStack.method_7909())) {
            return false;
        }
        if (this.count.isPresent() && this.count.get() > itemStack.method_7947()) {
            return false;
        }
        if (this.tag.isPresent()) {
            if (!itemStack.method_7985()) {
                return false;
            }
            class_2487 compoundTag = itemStack.method_7969();
            JsonElement jsonElement = (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)compoundTag);
            compoundTag = (class_2487)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)class_2509.field_11560, (Object)jsonElement);
            if (!this.tag.get().equals((Object)compoundTag)) {
                return false;
            }
        }
        return !this.requireEmptyTag || !itemStack.method_7985();
    }

    @Override
    public class_1856 getPreview() {
        return class_1856.method_8101((class_1799[])this.stacks.toArray(new class_1799[0]));
    }

    @Override
    public List<class_1799> getPreviewStacks() {
        return Collections.unmodifiableList(this.stacks.stream().map(class_1799::method_7972).peek(itemStack -> itemStack.method_7939(this.count.orElse(1).intValue())).peek(itemStack -> itemStack.method_7980((class_2487)this.tag.orElse(null))).collect(Collectors.toList()));
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("item", class_2378.field_11142.method_10221((Object)this.stacks.get(0).method_7909()).toString());
        this.count.ifPresent(integer -> jsonObject.addProperty("count", (Number)integer));
        if (this.requireEmptyTag) {
            jsonObject.addProperty("nbt", "empty");
        } else {
            this.tag.ifPresent(compoundTag -> jsonObject.add("nbt", (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)compoundTag)));
        }
        return jsonObject;
    }

    @Override
    public int getCount() {
        return this.count.orElse(1);
    }
}

