/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import reborncore.RebornCore;
import reborncore.common.crafting.ConditionManager;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.util.serialization.SerializationUtil;

public class RebornRecipeType<R extends RebornRecipe>
implements class_3956,
class_1865 {
    private final Class<R> clazz;
    private final class_2960 typeId;

    public RebornRecipeType(Class<R> clazz, class_2960 typeId) {
        this.clazz = clazz;
        this.typeId = typeId;
    }

    public R read(class_2960 recipeId, JsonObject json) {
        class_2960 type = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
        if (!type.equals((Object)this.typeId)) {
            throw new RuntimeException("RebornRecipe type not supported!");
        }
        R recipe = this.newRecipe(recipeId);
        try {
            if (!ConditionManager.shouldLoadRecipe(json)) {
                ((RebornRecipe)recipe).makeDummy();
                return recipe;
            }
            ((RebornRecipe)recipe).deserialize(json);
        }
        catch (Throwable t) {
            t.printStackTrace();
            RebornCore.LOGGER.error("Failed to read recipe: " + recipeId);
        }
        return recipe;
    }

    public JsonObject toJson(R recipe) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.typeId.toString());
        ((RebornRecipe)recipe).serialize(jsonObject);
        return jsonObject;
    }

    public R fromJson(class_2960 recipeType, JsonObject json) {
        return this.read(recipeType, json);
    }

    R newRecipe(class_2960 recipeId) {
        try {
            return (R)((RebornRecipe)this.clazz.getConstructor(RebornRecipeType.class, class_2960.class).newInstance(this, recipeId));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create new recipe class for " + recipeId + " using " + this.clazz.getName());
        }
    }

    public R read(class_2960 recipeId, class_2540 buffer) {
        String input = buffer.method_10800(buffer.readInt());
        R r = this.read(recipeId, (JsonObject)SerializationUtil.GSON_FLAT.fromJson(input, JsonObject.class));
        ((RebornRecipe)r).deserialize(buffer);
        return r;
    }

    public void method_8124(class_2540 buffer, class_1860 recipe) {
        JsonObject jsonObject = this.toJson((RebornRecipe)recipe);
        String output = SerializationUtil.GSON_FLAT.toJson((JsonElement)jsonObject);
        buffer.writeInt(output.length());
        buffer.method_10814(output);
        ((RebornRecipe)recipe).serialize(buffer);
    }

    public class_2960 getName() {
        return this.typeId;
    }

    public List<R> getRecipes(class_1937 world) {
        return RecipeUtils.getRecipes(world, this);
    }

    public Class<R> getRecipeClass() {
        return this.clazz;
    }
}

