/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.util.Tank;

public abstract class RebornFluidRecipe
extends RebornRecipe {
    @Nonnull
    private FluidInstance fluidInstance = FluidInstance.EMPTY;

    public RebornFluidRecipe(RebornRecipeType<?> type, class_2960 name) {
        super(type, name);
    }

    public RebornFluidRecipe(RebornRecipeType<?> type, class_2960 name, class_2371<RebornIngredient> ingredients, class_2371<class_1799> outputs, int power, int time) {
        super(type, name, ingredients, outputs, power, time);
    }

    public RebornFluidRecipe(RebornRecipeType<?> type, class_2960 name, class_2371<RebornIngredient> ingredients, class_2371<class_1799> outputs, int power, int time, FluidInstance fluidInstance) {
        this(type, name, ingredients, outputs, power, time);
        this.fluidInstance = fluidInstance;
    }

    @Override
    public void deserialize(JsonObject jsonObject) {
        super.deserialize(jsonObject);
        if (jsonObject.has("tank")) {
            JsonObject tank = jsonObject.get("tank").getAsJsonObject();
            class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)tank, (String)"fluid"));
            class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(identifier);
            FluidValue value = FluidValue.BUCKET;
            if (tank.has("amount")) {
                value = FluidValue.parseFluidValue(tank.get("amount"));
            }
            this.fluidInstance = new FluidInstance(fluid, value);
        }
    }

    public abstract Tank getTank(class_2586 var1);

    @Override
    public boolean canCraft(class_2586 be) {
        FluidInstance recipeFluid = this.fluidInstance;
        FluidInstance tankFluid = this.getTank(be).getFluidInstance();
        if (this.fluidInstance.isEmpty()) {
            return true;
        }
        if (tankFluid.isEmpty()) {
            return false;
        }
        return tankFluid.getFluid().equals(recipeFluid.getFluid()) && tankFluid.getAmount().equalOrMoreThan(recipeFluid.getAmount());
    }

    @Override
    public boolean onCraft(class_2586 be) {
        FluidInstance recipeFluid = this.fluidInstance;
        FluidInstance tankFluid = this.getTank(be).getFluidInstance();
        if (this.fluidInstance.isEmpty()) {
            return true;
        }
        if (tankFluid.isEmpty()) {
            return false;
        }
        if (tankFluid.getFluid().equals(recipeFluid.getFluid()) && tankFluid.getAmount().equalOrMoreThan(recipeFluid.getAmount())) {
            tankFluid.subtractAmount(recipeFluid.getAmount());
            return true;
        }
        return false;
    }

    @Nonnull
    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }
}

