/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.chunkloading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import reborncore.common.network.ClientBoundPackets;
import reborncore.common.util.NBTSerializable;
import reborncore.common.world.DataAttachment;
import reborncore.common.world.DataAttachmentProvider;

public class ChunkLoaderManager
implements DataAttachment {
    private static final class_3230<class_1923> CHUNK_LOADER = class_3230.method_14291((String)"reborncore:chunk_loader", Comparator.comparingLong(class_1923::method_8324));
    private final List<LoadedChunk> loadedChunks = new ArrayList<LoadedChunk>();

    public static ChunkLoaderManager get(class_1937 world) {
        return DataAttachmentProvider.get(world, ChunkLoaderManager.class);
    }

    @Override
    @Nonnull
    public class_2487 write() {
        class_2487 tag = new class_2487();
        class_2499 listTag = new class_2499();
        listTag.addAll((Collection)this.loadedChunks.stream().map(LoadedChunk::write).collect(Collectors.toList()));
        tag.method_10566("loadedchunks", (class_2520)listTag);
        return tag;
    }

    @Override
    public void read(@Nonnull class_2487 tag) {
        this.loadedChunks.clear();
        class_2499 listTag = tag.method_10554("loadedchunks", (int)tag.method_10711());
        this.loadedChunks.addAll(listTag.stream().map(tag1 -> (class_2487)tag1).map(LoadedChunk::new).collect(Collectors.toList()));
    }

    public Optional<LoadedChunk> getLoadedChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.getWorld().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.getChunk().equals((Object)chunkPos)).filter(loadedChunk -> loadedChunk.getChunkLoader().equals((Object)chunkLoader)).findFirst();
    }

    public Optional<LoadedChunk> getLoadedChunk(class_1937 world, class_1923 chunkPos) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.getWorld().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.getChunk().equals((Object)chunkPos)).findFirst();
    }

    public List<LoadedChunk> getLoadedChunks(class_1937 world, class_2338 chunkloader) {
        return this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.getWorld().equals((Object)ChunkLoaderManager.getWorldName(world))).filter(loadedChunk -> loadedChunk.getChunkLoader().equals((Object)chunkloader)).collect(Collectors.toList());
    }

    public boolean isChunkLoaded(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        return this.getLoadedChunk(world, chunkPos, chunkLoader).isPresent();
    }

    public boolean isChunkLoaded(class_1937 world, class_1923 chunkPos) {
        return this.getLoadedChunk(world, chunkPos).isPresent();
    }

    public void loadChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader, String player) {
        Validate.isTrue((!this.isChunkLoaded(world, chunkPos, chunkLoader) ? 1 : 0) != 0, (String)"chunk is already loaded", (Object[])new Object[0]);
        LoadedChunk loadedChunk = new LoadedChunk(chunkPos, ChunkLoaderManager.getWorldName(world), player, chunkLoader);
        this.loadedChunks.add(loadedChunk);
        class_3215 serverChunkManager = ((class_3218)world).method_14178();
        serverChunkManager.method_17297(CHUNK_LOADER, loadedChunk.getChunk(), 31, (Object)loadedChunk.getChunk());
    }

    public void unloadChunkLoader(class_1937 world, class_2338 chunkLoader) {
        this.getLoadedChunks(world, chunkLoader).forEach(loadedChunk -> this.unloadChunk(world, loadedChunk.getChunk(), chunkLoader));
    }

    public void unloadChunk(class_1937 world, class_1923 chunkPos, class_2338 chunkLoader) {
        Optional<LoadedChunk> optionalLoadedChunk = this.getLoadedChunk(world, chunkPos, chunkLoader);
        Validate.isTrue((boolean)optionalLoadedChunk.isPresent(), (String)"chunk is not loaded", (Object[])new Object[0]);
        LoadedChunk loadedChunk = optionalLoadedChunk.get();
        this.loadedChunks.remove(loadedChunk);
        if (!this.isChunkLoaded(world, loadedChunk.getChunk())) {
            class_3215 serverChunkManager = ((class_3218)world).method_14178();
            serverChunkManager.method_17300(CHUNK_LOADER, loadedChunk.getChunk(), 31, (Object)loadedChunk.getChunk());
        }
    }

    public static class_2960 getWorldName(class_1937 world) {
        Validate.isTrue((boolean)(world instanceof class_3218), (String)"world must be a ServerWorld", (Object[])new Object[0]);
        return class_2378.field_11155.method_10221((Object)world.method_8597().method_12460());
    }

    public void syncChunkLoaderToClient(class_3222 serverPlayerEntity, class_2338 chunkLoader) {
        this.syncToClient(serverPlayerEntity, this.loadedChunks.stream().filter(loadedChunk -> loadedChunk.getChunkLoader().equals((Object)chunkLoader)).collect(Collectors.toList()));
    }

    public void syncAllToClient(class_3222 serverPlayerEntity) {
        this.syncToClient(serverPlayerEntity, this.loadedChunks);
    }

    public void clearClient(class_3222 serverPlayerEntity) {
        this.syncToClient(serverPlayerEntity, Collections.emptyList());
    }

    public void syncToClient(class_3222 serverPlayerEntity, List<LoadedChunk> chunks) {
        serverPlayerEntity.field_13987.method_14364(ClientBoundPackets.createPacketSyncLoadedChunks(chunks));
    }

    public static class LoadedChunk
    implements NBTSerializable {
        private class_1923 chunk;
        private class_2960 world;
        private String player;
        private class_2338 chunkLoader;

        public LoadedChunk(class_1923 chunk, class_2960 world, String player, class_2338 chunkLoader) {
            this.chunk = chunk;
            this.world = world;
            this.player = player;
            this.chunkLoader = chunkLoader;
            Validate.isTrue((!StringUtils.isBlank((CharSequence)player) ? 1 : 0) != 0, (String)"Player cannot be blank", (Object[])new Object[0]);
        }

        public LoadedChunk(class_2487 tag) {
            this.read(tag);
        }

        @Override
        @Nonnull
        public class_2487 write() {
            class_2487 tag = new class_2487();
            tag.method_10544("chunk", this.chunk.method_8324());
            tag.method_10582("world", this.world.toString());
            tag.method_10582("player", this.player);
            tag.method_10544("chunkLoader", this.chunkLoader.method_10063());
            return tag;
        }

        @Override
        public void read(@Nonnull class_2487 tag) {
            this.chunk = new class_1923(tag.method_10537("chunk"));
            this.world = new class_2960(tag.method_10558("world"));
            this.player = tag.method_10558("player");
            this.chunkLoader = class_2338.method_10092((long)tag.method_10537("chunkLoader"));
        }

        public class_1923 getChunk() {
            return this.chunk;
        }

        public class_2960 getWorld() {
            return this.world;
        }

        public String getPlayer() {
            return this.player;
        }

        public class_2338 getChunkLoader() {
            return this.chunkLoader;
        }
    }
}

