/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.screen.builder;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.RebornCore;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.client.gui.slots.SlotFake;
import reborncore.client.gui.slots.SlotOutput;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.client.screen.builder.Syncable;
import reborncore.client.screen.builder.slot.FilteredSlot;
import reborncore.client.screen.builder.slot.UpgradeSlot;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import team.reborn.energy.Energy;

public class BlockEntityScreenHandlerBuilder {
    private final class_1263 inventory;
    private final class_2586 blockEntity;
    private final ScreenHandlerBuilder parent;
    private final int rangeStart;

    BlockEntityScreenHandlerBuilder(ScreenHandlerBuilder parent, class_2586 blockEntity) {
        if (!(blockEntity instanceof class_1263)) {
            throw new RuntimeException(blockEntity.getClass().getName() + " is not an inventory");
        }
        this.inventory = (class_1263)blockEntity;
        this.blockEntity = blockEntity;
        this.parent = parent;
        this.rangeStart = parent.slots.size();
        if (this.inventory instanceof IUpgradeable) {
            this.upgradeSlots((IUpgradeable)this.inventory);
        }
        if (blockEntity instanceof MachineBaseBlockEntity) {
            this.sync(((MachineBaseBlockEntity)blockEntity).getRedstoneConfiguration());
        }
    }

    public BlockEntityScreenHandlerBuilder slot(int index, int x, int y) {
        this.parent.slots.add(new BaseSlot(this.inventory, index, x, y));
        return this;
    }

    public BlockEntityScreenHandlerBuilder slot(int index, int x, int y, Predicate<class_1799> filter) {
        this.parent.slots.add(new BaseSlot(this.inventory, index, x, y, filter));
        return this;
    }

    public BlockEntityScreenHandlerBuilder outputSlot(int index, int x, int y) {
        this.parent.slots.add(new SlotOutput(this.inventory, index, x, y));
        return this;
    }

    public BlockEntityScreenHandlerBuilder fakeSlot(int index, int x, int y) {
        this.parent.slots.add(new SlotFake(this.inventory, index, x, y, false, false, Integer.MAX_VALUE));
        return this;
    }

    public BlockEntityScreenHandlerBuilder filterSlot(int index, int x, int y, Predicate<class_1799> filter) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(filter));
        return this;
    }

    public BlockEntityScreenHandlerBuilder energySlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(Energy::valid));
        return this;
    }

    public BlockEntityScreenHandlerBuilder fluidSlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(stack -> stack.method_7909() instanceof ItemFluidInfo));
        return this;
    }

    public BlockEntityScreenHandlerBuilder fuelSlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(class_2609::method_11195));
        return this;
    }

    @Deprecated
    public BlockEntityScreenHandlerBuilder upgradeSlot(int index, int x, int y) {
        this.parent.slots.add(new FilteredSlot(this.inventory, index, x, y).setFilter(stack -> stack.method_7909() instanceof IUpgrade));
        return this;
    }

    private BlockEntityScreenHandlerBuilder upgradeSlots(IUpgradeable upgradeable) {
        if (upgradeable.canBeUpgraded()) {
            for (int i = 0; i < upgradeable.getUpgradeSlotCount(); ++i) {
                this.parent.slots.add(new UpgradeSlot(upgradeable.getUpgradeInvetory(), i, -18, i * 18 + 12));
            }
        }
        return this;
    }

    public <T> BlockEntityScreenHandlerBuilder sync(Supplier<T> supplier, Consumer<T> setter) {
        this.parent.objectValues.add((Pair<Supplier, Consumer>)Pair.of(supplier, setter));
        return this;
    }

    public BlockEntityScreenHandlerBuilder sync(Syncable syncable) {
        syncable.getSyncPair(this.parent.objectValues);
        return this;
    }

    public BlockEntityScreenHandlerBuilder syncEnergyValue() {
        if (this.blockEntity instanceof PowerAcceptorBlockEntity) {
            PowerAcceptorBlockEntity powerAcceptor = (PowerAcceptorBlockEntity)this.blockEntity;
            return this.sync(powerAcceptor::getEnergy, powerAcceptor::setEnergy).sync(() -> powerAcceptor.extraPowerStorage, powerAcceptor::setExtraPowerStorage).sync(powerAcceptor::getPowerChange, powerAcceptor::setPowerChange);
        }
        RebornCore.LOGGER.error(this.inventory + " is not an instance of TilePowerAcceptor! Energy cannot be synced.");
        return this;
    }

    public BlockEntityScreenHandlerBuilder syncCrafterValue() {
        if (this.blockEntity instanceof IRecipeCrafterProvider) {
            IRecipeCrafterProvider recipeCrafter = (IRecipeCrafterProvider)this.blockEntity;
            return this.sync(() -> recipeCrafter.getRecipeCrafter().currentTickTime, time -> {
                recipeCrafter.getRecipeCrafter().currentTickTime = time;
            }).sync(() -> recipeCrafter.getRecipeCrafter().currentNeededTicks, ticks -> {
                recipeCrafter.getRecipeCrafter().currentNeededTicks = ticks;
            });
        }
        RebornCore.LOGGER.error(this.inventory + " is not an instance of IRecipeCrafterProvider! Craft progress cannot be synced.");
        return this;
    }

    public BlockEntityScreenHandlerBuilder onCraft(Consumer<class_1715> onCraft) {
        this.parent.craftEvents.add(onCraft);
        return this;
    }

    public ScreenHandlerBuilder addInventory() {
        this.parent.blockEntityInventoryRanges.add((Range<Integer>)Range.between((Comparable)Integer.valueOf(this.rangeStart), (Comparable)Integer.valueOf(this.parent.slots.size() - 1)));
        return this.parent;
    }
}

