/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4493;
import net.minecraft.class_918;
import reborncore.client.RenderUtil;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.elements.ISprite;
import reborncore.client.gui.builder.slot.elements.OffsetSprite;
import reborncore.client.gui.builder.slot.elements.Sprite;
import reborncore.client.gui.builder.slot.elements.SpriteContainer;
import reborncore.client.gui.guibuilder.GuiBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;

public class ElementBase {
    public int x;
    public int y;
    public boolean isHovering = false;
    public boolean isDragging = false;
    public boolean isPressing = false;
    public boolean isReleasing = false;
    public boolean startPressLast = false;
    public boolean isHoveringLast = false;
    public boolean isDraggingLast = false;
    public boolean isPressingLast = false;
    public boolean isReleasingLast = false;
    public List<Action> hoverActions = new ArrayList<Action>();
    public List<Action> dragActions = new ArrayList<Action>();
    public List<Action> startPressActions = new ArrayList<Action>();
    public List<Action> pressActions = new ArrayList<Action>();
    public List<Action> releaseActions = new ArrayList<Action>();
    public SpriteContainer container;
    public List<UpdateAction> updateActions = new ArrayList<UpdateAction>();
    public List<UpdateAction> buttonUpdate = new ArrayList<UpdateAction>();
    private int width;
    private int height;
    public static final class_2960 MECH_ELEMENTS = new class_2960("reborncore", "textures/gui/elements.png");

    public ElementBase(int x, int y, SpriteContainer container) {
        this.container = container;
        this.x = x;
        this.y = y;
    }

    public ElementBase(int x, int y, ISprite ... sprites) {
        this.container = new SpriteContainer();
        for (ISprite sprite : sprites) {
            this.container.addSprite(sprite);
        }
        this.x = x;
        this.y = y;
    }

    public ElementBase(int x, int y, int width, int height) {
        this.container = new SpriteContainer();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ElementBase(int x, int y, int width, int height, SpriteContainer container) {
        this.container = container;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ElementBase(int x, int y, int width, int height, ISprite ... sprites) {
        this.container = new SpriteContainer();
        for (ISprite sprite : sprites) {
            this.container.addSprite(sprite);
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public SpriteContainer getSpriteContainer() {
        return this.container;
    }

    public void adjustDimensions(MachineBaseBlockEntity provider) {
        if (this.container.offsetSprites != null) {
            for (OffsetSprite offsetSprite : this.container.offsetSprites) {
                if (offsetSprite.getSprite().getSprite((MachineBaseBlockEntity)provider).width + offsetSprite.getOffsetX(provider) > this.width) {
                    this.width = offsetSprite.getSprite().getSprite((MachineBaseBlockEntity)provider).width + offsetSprite.getOffsetX(provider);
                }
                if (offsetSprite.getSprite().getSprite((MachineBaseBlockEntity)provider).height + offsetSprite.getOffsetY(provider) <= this.height) continue;
                this.height = offsetSprite.getSprite().getSprite((MachineBaseBlockEntity)provider).height + offsetSprite.getOffsetY(provider);
            }
        }
    }

    public void draw(GuiBase<?> gui) {
        for (OffsetSprite sprite : this.getSpriteContainer().offsetSprites) {
            this.drawSprite(gui, sprite.getSprite(), this.x + sprite.getOffsetX(gui.getMachine()), this.y + sprite.getOffsetY(gui.getMachine()));
        }
    }

    public void renderUpdate(GuiBase<?> gui) {
        this.isHoveringLast = this.isHovering;
        this.isPressingLast = this.isPressing;
        this.isDraggingLast = this.isDragging;
        this.isReleasingLast = this.isReleasing;
    }

    public void update(GuiBase<?> gui) {
        for (UpdateAction action : this.updateActions) {
            action.update(gui, this);
        }
    }

    public ElementBase addUpdateAction(UpdateAction action) {
        this.updateActions.add(action);
        return this;
    }

    public ElementBase setWidth(int width) {
        this.width = width;
        return this;
    }

    public ElementBase setHeight(int height) {
        this.height = height;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public ElementBase setX(int x) {
        this.x = x;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public ElementBase setY(int y) {
        this.y = y;
        return this;
    }

    public int getWidth(MachineBaseBlockEntity provider) {
        this.adjustDimensions(provider);
        return this.width;
    }

    public int getHeight(MachineBaseBlockEntity provider) {
        this.adjustDimensions(provider);
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ElementBase addHoverAction(Action action) {
        this.hoverActions.add(action);
        return this;
    }

    public ElementBase addDragAction(Action action) {
        this.dragActions.add(action);
        return this;
    }

    public ElementBase addStartPressAction(Action action) {
        this.startPressActions.add(action);
        return this;
    }

    public ElementBase addPressAction(Action action) {
        this.pressActions.add(action);
        return this;
    }

    public ElementBase addReleaseAction(Action action) {
        this.releaseActions.add(action);
        return this;
    }

    public boolean onHover(MachineBaseBlockEntity provider, GuiBase<?> gui, double mouseX, double mouseY) {
        for (Action action : this.hoverActions) {
            action.execute(this, gui, provider, mouseX, mouseY);
        }
        return !this.hoverActions.isEmpty();
    }

    public boolean onDrag(MachineBaseBlockEntity provider, GuiBase<?> gui, double mouseX, double mouseY) {
        for (Action action : this.dragActions) {
            action.execute(this, gui, provider, mouseX, mouseY);
        }
        return !this.dragActions.isEmpty();
    }

    public boolean onStartPress(MachineBaseBlockEntity provider, GuiBase<?> gui, double mouseX, double mouseY) {
        for (Action action : this.startPressActions) {
            action.execute(this, gui, provider, mouseX, mouseY);
        }
        return !this.startPressActions.isEmpty();
    }

    public boolean onRelease(MachineBaseBlockEntity provider, GuiBase<?> gui, double mouseX, double mouseY) {
        for (Action action : this.releaseActions) {
            if (!action.execute(this, gui, provider, mouseX, mouseY)) continue;
            return true;
        }
        if (this.isPressing) {
            for (Action action : this.pressActions) {
                action.execute(this, gui, provider, mouseX, mouseY);
            }
        }
        return !this.releaseActions.isEmpty() || !this.pressActions.isEmpty();
    }

    public void drawRect(GuiBase<?> gui, int x, int y, int width, int height, int colour) {
        this.drawGradientRect(gui, x, y, width, height, colour, colour);
    }

    public void drawGradientRect(GuiBase<?> gui, int x, int y, int width, int height, int startColor, int endColor) {
        x = this.adjustX(gui, x);
        y = this.adjustY(gui, y);
        int left = x;
        int top = y;
        int right = x + width;
        int bottom = y + height;
        RenderUtil.drawGradientRect(0, left, top, right, bottom, startColor, endColor);
    }

    public int adjustX(GuiBase<?> gui, int x) {
        return gui.getGuiLeft() + x;
    }

    public int adjustY(GuiBase<?> gui, int y) {
        return gui.getGuiTop() + y;
    }

    public boolean isInRect(GuiBase<?> gui, int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return gui.isPointInRect(x + gui.getGuiLeft(), y + gui.getGuiTop(), xSize, ySize, mouseX, mouseY);
    }

    public void drawString(GuiBase<?> gui, String string, int x, int y, int color) {
        x = this.adjustX(gui, x);
        y = this.adjustY(gui, y);
        gui.getTextRenderer().method_1729(string, (float)x, (float)y, color);
    }

    public void drawString(GuiBase<?> gui, String string, int x, int y) {
        this.drawString(gui, string, x, y, 0xFFFFFF);
    }

    public void setTextureSheet(class_2960 textureLocation) {
        class_310.method_1551().method_1531().method_22813(textureLocation);
    }

    public void drawCenteredString(GuiBase<?> gui, String string, int y, int colour) {
        this.drawString(gui, string, gui.getScreenWidth() / 2 - gui.getTextRenderer().method_1727(string) / 2, y, colour);
    }

    public void drawCenteredString(GuiBase<?> gui, String string, int x, int y, int colour) {
        this.drawString(gui, string, x - gui.getTextRenderer().method_1727(string) / 2, y, colour);
    }

    public int getStringWidth(String string) {
        return class_310.method_1551().field_1772.method_1727(string);
    }

    public void drawSprite(GuiBase<?> gui, ISprite iSprite, int x, int y) {
        Sprite sprite = iSprite.getSprite(gui.getMachine());
        if (sprite != null) {
            if (sprite.hasTextureInfo()) {
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.setTextureSheet(sprite.textureLocation);
                gui.method_25302(x + gui.getGuiLeft(), y + gui.getGuiTop(), sprite.x, sprite.y, sprite.width, sprite.height);
            }
            if (sprite.hasStack()) {
                RenderSystem.pushMatrix();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
                class_918 itemRenderer = class_310.method_1551().method_1480();
                itemRenderer.method_4023(sprite.itemStack, x + gui.getGuiLeft(), y + gui.getGuiTop());
                RenderSystem.disableLighting();
                RenderSystem.popMatrix();
            }
        }
    }

    public int getScaledBurnTime(int scale, int burnTime, int totalBurnTime) {
        return (int)((float)burnTime / (float)totalBurnTime * (float)scale);
    }

    public int getPercentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    public void drawDefaultBackground(class_437 gui, int x, int y, int width, int height) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310.method_1551().method_1531().method_22813(GuiBuilder.defaultTextureSheet);
        gui.method_25302(x, y, 0, 0, width / 2, height / 2);
        gui.method_25302(x + width / 2, y, 150 - width / 2, 0, width / 2, height / 2);
        gui.method_25302(x, y + height / 2, 0, 150 - height / 2, width / 2, height / 2);
        gui.method_25302(x + width / 2, y + height / 2, 150 - width / 2, 150 - height / 2, width / 2, height / 2);
    }

    public static interface UpdateAction {
        public void update(GuiBase<?> var1, ElementBase var2);
    }

    public static interface Action {
        public boolean execute(ElementBase var1, GuiBase<?> var2, MachineBaseBlockEntity var3, double var4, double var6);
    }
}

