/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1799;
import org.apache.commons.lang3.Validate;
import reborncore.client.gui.builder.GuiBase;
import reborncore.common.blockentity.MachineBaseBlockEntity;

public class GuiTab {
    private final Builder builder;
    private final MachineBaseBlockEntity machineBaseBlockEntity;
    private final GuiBase<?> guiBase;

    private GuiTab(Builder builder, MachineBaseBlockEntity machineBaseBlockEntity, GuiBase<?> guiBase) {
        this.builder = builder;
        this.machineBaseBlockEntity = machineBaseBlockEntity;
        this.guiBase = guiBase;
    }

    public String name() {
        return this.builder.name;
    }

    public boolean enabled() {
        return (Boolean)this.builder.enabled.apply(this);
    }

    public class_1799 stack() {
        return (class_1799)this.builder.stack.apply(this);
    }

    public MachineBaseBlockEntity machine() {
        return this.machineBaseBlockEntity;
    }

    public void draw(int x, int y) {
        this.builder.draw.draw(this.guiBase, x, y);
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        return this.builder.click.click(this.guiBase, mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        return this.builder.mouseReleased.mouseReleased(this.guiBase, mouseX, mouseY, mouseButton);
    }

    public boolean keyPress(int keyCode, int scanCode, int modifiers) {
        return this.builder.keyPressed.keyPress(this.guiBase, keyCode, scanCode, modifiers);
    }

    public List<String> getTips() {
        LinkedList<String> tips = new LinkedList<String>();
        this.builder.tips.accept(tips);
        return tips;
    }

    public boolean hideGuiElements() {
        return this.builder.hideGuiElements;
    }

    public GuiBase<?> gui() {
        return this.guiBase;
    }

    public static class Builder {
        private String name;
        private Function<GuiTab, Boolean> enabled = tab -> true;
        private Function<GuiTab, class_1799> stack = tab -> class_1799.field_8037;
        private Draw draw = (gui, x, y) -> {};
        private Click click = (guiBase, mouseX, mouseY, mouseButton) -> false;
        private MouseReleased mouseReleased = (guiBase, mouseX, mouseY, state) -> false;
        private KeyPressed keyPressed = (guiBase, keyCode, scanCode, modifiers) -> false;
        private Consumer<List<String>> tips = strings -> {};
        private boolean hideGuiElements = false;

        public static Builder builder() {
            return new Builder();
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder stack(Function<GuiTab, class_1799> function) {
            this.stack = function;
            return this;
        }

        public Builder enabled(Function<GuiTab, Boolean> function) {
            this.enabled = function;
            return this;
        }

        public Builder draw(Draw draw) {
            this.draw = draw;
            return this;
        }

        public Builder click(Click click) {
            this.click = click;
            return this;
        }

        public Builder mouseReleased(MouseReleased mouseReleased) {
            this.mouseReleased = mouseReleased;
            return this;
        }

        public Builder keyPressed(KeyPressed keyPressed) {
            this.keyPressed = keyPressed;
            return this;
        }

        public Builder tips(Consumer<List<String>> listConsumer) {
            this.tips = listConsumer;
            return this;
        }

        public Builder hideGuiElements() {
            this.hideGuiElements = true;
            return this;
        }

        public GuiTab build(MachineBaseBlockEntity blockEntity, GuiBase<?> guiBase) {
            Validate.notBlank((CharSequence)this.name, (String)"No name provided", (Object[])new Object[0]);
            return new GuiTab(this, blockEntity, guiBase);
        }

        public static interface KeyPressed {
            public boolean keyPress(GuiBase<?> var1, int var2, int var3, int var4);
        }

        public static interface MouseReleased {
            public boolean mouseReleased(GuiBase<?> var1, double var2, double var4, int var6);
        }

        public static interface Click {
            public boolean click(GuiBase<?> var1, double var2, double var4, int var6);
        }

        public static interface Draw {
            public void draw(GuiBase<?> var1, int var2, int var3);
        }
    }
}

