/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.world;

import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3122;
import net.minecraft.class_3124;
import net.minecraft.class_3532;

//Thanks vanilla, just to add end ores :/
public class CustomOreFeature extends class_3122 {

	public static final class_3031<class_3124> CUSTOM_ORE_FEATURE = class_2378.method_10230(class_2378.field_11138, new class_2960("reborncore", "custom_ore"), new CustomOreFeature(CustomOreFeatureConfig::method_13634));

	public CustomOreFeature(Function<Dynamic<?>, ? extends class_3124> function){
		super(function);
	}

	@Override
	protected boolean method_13629(class_1936 world, Random random, class_3124 config, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6, int int_1, int int_2, int int_3, int int_4, int int_5) {
		int int_6 = 0;
		BitSet bitSet = new BitSet(int_4 * int_5 * int_4);
		class_2338.class_2339 mutablePos = new class_2338.class_2339();
		double[] doubles_1 = new double[config.field_13723 * 4];

		int int_8;
		double double_12;
		double double_13;
		double double_14;
		double double_15;
		for(int_8 = 0; int_8 < config.field_13723; ++int_8) {
			float float_1 = (float)int_8 / (float)config.field_13723;
			double_12 = class_3532.method_16436((double)float_1, double_1, double_2);
			double_13 = class_3532.method_16436((double)float_1, double_5, double_6);
			double_14 = class_3532.method_16436((double)float_1, double_3, double_4);
			double_15 = random.nextDouble() * (double)config.field_13723 / 16.0D;
			double double_11 = ((double)(class_3532.method_15374(3.1415927F * float_1) + 1.0F) * double_15 + 1.0D) / 2.0D;
			doubles_1[int_8 * 4 + 0] = double_12;
			doubles_1[int_8 * 4 + 1] = double_13;
			doubles_1[int_8 * 4 + 2] = double_14;
			doubles_1[int_8 * 4 + 3] = double_11;
		}

		for(int_8 = 0; int_8 < config.field_13723 - 1; ++int_8) {
			if (doubles_1[int_8 * 4 + 3] > 0.0D) {
				for(int int_9 = int_8 + 1; int_9 < config.field_13723; ++int_9) {
					if (doubles_1[int_9 * 4 + 3] > 0.0D) {
						double_12 = doubles_1[int_8 * 4 + 0] - doubles_1[int_9 * 4 + 0];
						double_13 = doubles_1[int_8 * 4 + 1] - doubles_1[int_9 * 4 + 1];
						double_14 = doubles_1[int_8 * 4 + 2] - doubles_1[int_9 * 4 + 2];
						double_15 = doubles_1[int_8 * 4 + 3] - doubles_1[int_9 * 4 + 3];
						if (double_15 * double_15 > double_12 * double_12 + double_13 * double_13 + double_14 * double_14) {
							if (double_15 > 0.0D) {
								doubles_1[int_9 * 4 + 3] = -1.0D;
							} else {
								doubles_1[int_8 * 4 + 3] = -1.0D;
							}
						}
					}
				}
			}
		}

		for(int_8 = 0; int_8 < config.field_13723; ++int_8) {
			double double_16 = doubles_1[int_8 * 4 + 3];
			if (double_16 >= 0.0D) {
				double double_17 = doubles_1[int_8 * 4 + 0];
				double double_18 = doubles_1[int_8 * 4 + 1];
				double double_19 = doubles_1[int_8 * 4 + 2];
				int int_11 = Math.max(class_3532.method_15357(double_17 - double_16), int_1);
				int int_12 = Math.max(class_3532.method_15357(double_18 - double_16), int_2);
				int int_13 = Math.max(class_3532.method_15357(double_19 - double_16), int_3);
				int int_14 = Math.max(class_3532.method_15357(double_17 + double_16), int_11);
				int int_15 = Math.max(class_3532.method_15357(double_18 + double_16), int_12);
				int int_16 = Math.max(class_3532.method_15357(double_19 + double_16), int_13);

				for(int x = int_11; x <= int_14; ++x) {
					double double_20 = ((double)x + 0.5D - double_17) / double_16;
					if (double_20 * double_20 < 1.0D) {
						for(int y = int_12; y <= int_15; ++y) {
							double double_21 = ((double)y + 0.5D - double_18) / double_16;
							if (double_20 * double_20 + double_21 * double_21 < 1.0D) {
								for(int z = int_13; z <= int_16; ++z) {
									double double_22 = ((double)z + 0.5D - double_19) / double_16;
									if (double_20 * double_20 + double_21 * double_21 + double_22 * double_22 < 1.0D) {
										int int_20 = x - int_1 + (y - int_2) * int_4 + (z - int_3) * int_4 * int_5;
										if (!bitSet.get(int_20)) {
											bitSet.set(int_20);
											mutablePos.method_10103(x, y, z);

											//Just added this line in
											CustomOreFeatureConfig customConfig = (CustomOreFeatureConfig) config;
											if (customConfig.blockPredicate.test(world.method_8320(mutablePos))) {
												world.method_8652(mutablePos, config.field_13724, 2);
												++int_6;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		return int_6 > 0;
	}

}
