/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.hud;

import com.google.common.collect.Lists;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_918;
import org.lwjgl.opengl.GL11;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergyHolder;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Prospector
 */
public class StackInfoHUD implements HudRenderCallback {

	public static List<StackInfoElement> ELEMENTS = new ArrayList<>();
	private static class_310 mc = class_310.method_1551();
	private int x = 2;
	private int y = 7;

	public static void registerElement(StackInfoElement element) {
		ELEMENTS.add(element);
	}

	public void drawStackInfoHud(class_1041 res) {
		class_1657 player = mc.field_1724;
		if (player == null){
			return;
		}
		List<class_1799> stacks = new ArrayList<>();
		stacks.add(player.method_6047());
		stacks.add(player.method_6079());

		for (class_1799 stack : player.method_5661()) {
			stacks.add(stack);
		}
		x = RebornCoreConfig.stackInfoX;

		if (RebornCoreConfig.stackInfoCorner == 2 || RebornCoreConfig.stackInfoCorner == 3) {
			stacks = Lists.reverse(stacks);
			// 20 for line height and additionally padding from configuration file
			y = res.method_4502() - 20 - RebornCoreConfig.stackInfoY;
		} else {
			y = RebornCoreConfig.stackInfoY;
		}

		for (class_1799 stack : stacks) {
			addInfo(stack, res);
		}
	}

	private void addInfo(class_1799 stack, class_1041 res) {
		if (stack == class_1799.field_8037) {
			return;
		}

		String text;
		if (stack.method_7909() instanceof EnergyHolder) {

			double maxCharge = Energy.of(stack).getMaxStored();
			double currentCharge = Energy.of(stack).getEnergy();

			class_124 color = StringUtils.getPercentageColour(percentage(maxCharge, currentCharge));
			text = color + PowerSystem.getLocaliszedPowerFormattedNoSuffix(currentCharge)
					+ "/" + PowerSystem.getLocaliszedPowerFormattedNoSuffix(maxCharge) + " "
					+ PowerSystem.getDisplayPower().abbreviation + class_124.field_1080;
			if (stack.method_7969() != null && stack.method_7969().method_10545("isActive")) {
				if (stack.method_7969().method_10577("isActive")) {
					text = text + class_124.field_1065 + " (" + StringUtils.t("reborncore.message.active")
							+ class_124.field_1065 + ")" + class_124.field_1080;
				} else {
					text = text + class_124.field_1065 + " (" + StringUtils.t("reborncore.message.inactive")
							+ class_124.field_1065 + ")" + class_124.field_1080;
				}
			}

			if (RebornCoreConfig.stackInfoCorner == 1 || RebornCoreConfig.stackInfoCorner == 2) {
				int strWidth = mc.field_1772.method_1727(text);
				// 18 for item icon and additionally padding from configuration file
				x = res.method_4486() - strWidth - 18 - RebornCoreConfig.stackInfoX;
			}

			renderStackForInfo(stack);
			mc.field_1772.method_1720(text, x + 18, y, 0);

			if (RebornCoreConfig.stackInfoCorner == 0 || RebornCoreConfig.stackInfoCorner == 1) {
				y += 20;
			} else {
				y -= 20;
			}
		}

		for (StackInfoElement element : ELEMENTS) {
			if (!element.getText(stack).equals("")) {
				renderStackForInfo(stack);
				mc.field_1772.method_1720(element.getText(stack), x + 18, y, 0);
				y += 20;
			}
		}
	}

	private void renderStackForInfo(class_1799 stack) {
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		GL11.glEnable(32826);
		class_308.method_22890();
		if (stack.method_7960()) {
			return;
		}
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

		class_918 itemRenderer = class_310.method_1551().method_1480();
		itemRenderer.method_4023(stack, x, y - 5);

		GL11.glDisable(GL11.GL_LIGHTING);
	}

	private int percentage(double MaxValue, double CurrentValue) {
		if (CurrentValue == 0)
			return 0;
		return (int) ((CurrentValue * 100.0f) / MaxValue);
	}

	@Override
	public void onHudRender(float tickDelta) {
		if (mc.field_1690.field_1842) {
			return;
		}
		if (!RebornCoreConfig.ShowStackInfoHUD) {
			return;
		}
		if (mc.method_1569() || (mc.field_1755 != null && mc.field_1690.field_1866)) {
			drawStackInfoHud(mc.method_22683());
		}
	}
}
