/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui.builder;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_465;
import org.lwjgl.glfw.GLFW;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.slot.PlayerInventorySlot;
import reborncore.client.gui.builder.slot.FluidConfigGui;
import reborncore.client.gui.builder.slot.GuiTab;
import reborncore.client.gui.builder.slot.SlotConfigGui;
import reborncore.client.gui.builder.widget.GuiButtonHologram;
import reborncore.client.gui.guibuilder.GuiBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.StringUtils;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * Created by Prospector
 */

public class GuiBase<T extends class_1703> extends class_465<T> {

	public static FluidCellProvider fluidCellProvider = fluid -> class_1799.field_8037;
	public static class_1799 wrenchStack = class_1799.field_8037;

	private List<GuiTab.Builder> tabBuilders = class_156.method_654(new ArrayList<>(), builders -> {
		builders.add(GuiTab.Builder.builder()
				.name("reborncore.gui.tooltip.config_slots")
				.enabled(guiTab -> guiTab.machine().hasSlotConfig())
				.stack(guiTab -> wrenchStack)
				.draw(SlotConfigGui::draw)
				.click(SlotConfigGui::mouseClicked)
				.mouseReleased(SlotConfigGui::mouseReleased)
				.hideGuiElements()
				.keyPressed((guiBase, keyCode, scanCode, modifiers) -> {
					if (method_25441() && keyCode == GLFW.GLFW_KEY_C) {
						SlotConfigGui.copyToClipboard();
						return true;
					} else if (method_25441() && keyCode == GLFW.GLFW_KEY_V) {
						SlotConfigGui.pasteFromClipboard();
						return true;
					} else if (keyCode == GLFW.GLFW_KEY_ESCAPE && SlotConfigGui.selectedSlot != -1) {
						SlotConfigGui.reset();
						return true;
					}
					return false;
				})
				.tips(tips -> {
					tips.add("reborncore.gui.slotconfigtip.slot");
					tips.add("reborncore.gui.slotconfigtip.side1");
					tips.add("reborncore.gui.slotconfigtip.side2");
					tips.add("reborncore.gui.slotconfigtip.side3");
					tips.add("reborncore.gui.slotconfigtip.copy1");
					tips.add("reborncore.gui.slotconfigtip.copy2");
				})
		);

		builders.add(GuiTab.Builder.builder()
				.name("reborncore.gui.tooltip.config_fluids")
				.enabled(guiTab -> guiTab.machine().showTankConfig())
				.stack(guiTab -> GuiBase.fluidCellProvider.provide(class_3612.field_15908))
				.draw(FluidConfigGui::draw)
				.click(FluidConfigGui::mouseClicked)
				.mouseReleased(FluidConfigGui::mouseReleased)
				.hideGuiElements()
		);

		builders.add(GuiTab.Builder.builder()
				.name("reborncore.gui.tooltip.config_redstone")
				.stack(guiTab -> new class_1799(class_1802.field_8725))
				.draw(RedstoneConfigGui::draw)
				.click(RedstoneConfigGui::mouseClicked)
		);
	});

	public GuiBuilder builder = new GuiBuilder();
	public class_2586 be;
	@Nullable
	public BuiltScreenHandler builtScreenHandler;
	private int xSize = 176;
	private int ySize = 176;

	private GuiTab selectedTab;
	private List<GuiTab> tabs;

	public boolean upgrades;

	public GuiBase(class_1657 player, class_2586 blockEntity, T screenHandler) {
		super(screenHandler, player.field_7514, new class_2585(class_1074.method_4662(blockEntity.method_11010().method_26204().method_9539())));
		this.be = blockEntity;
		this.builtScreenHandler = (BuiltScreenHandler) screenHandler;
		selectedTab = null;
		populateSlots();
	}

	private void populateSlots() {
		tabs = tabBuilders.stream()
				.map(builder -> builder.build(getMachine(), this))
				.filter(GuiTab::enabled)
				.collect(Collectors.toList());
	}

	public int getScreenWidth() {
		return field_2792;
	}

	public void drawSlot(int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += this.field_2776;
			y += this.field_2800;
		}
		builder.drawSlot(this, x - 1, y - 1);
	}

	public void drawOutputSlotBar(int x, int y, int count, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += this.field_2776;
			y += this.field_2800;
		}
		builder.drawOutputSlotBar(this, x - 4, y - 4, count);
	}

	public void drawArmourSlots(int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += this.field_2776;
			y += this.field_2800;
		}
		builder.drawSlot(this, x - 1, y - 1);
		builder.drawSlot(this, x - 1, y - 1 + 18);
		builder.drawSlot(this, x - 1, y - 1 + 18 + 18);
		builder.drawSlot(this, x - 1, y - 1 + 18 + 18 + 18);
	}

	public void drawOutputSlot(int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += this.field_2776;
			y += this.field_2800;
		}
		builder.drawOutputSlot(this, x - 5, y - 5);
	}

	@Override
	public void method_25426() {
		super.method_25426();
		if (isConfigEnabled()) {
			SlotConfigGui.init(this);
		}
		if (isConfigEnabled() && getMachine().getTank() != null && getMachine().showTankConfig()) {
			FluidConfigGui.init(this);
		}
	}

	@Override
	protected void method_2389(float lastFrameDuration, int mouseX, int mouseY) {
		RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
		method_25420();
		boolean drawPlayerSlots = selectedTab == null && drawPlayerSlots();
		updateSlotDraw(drawPlayerSlots);
		builder.drawDefaultBackground(this, field_2776, field_2800, xSize, ySize);
		if (drawPlayerSlots) {
			builder.drawPlayerSlots(this, field_2776 + field_2792 / 2, field_2800 + 93, true);
		}
		if (tryAddUpgrades() && be instanceof IUpgradeable) {
			IUpgradeable upgradeable = (IUpgradeable) be;
			if (upgradeable.canBeUpgraded()) {
				builder.drawUpgrades(this, field_2776 - 24, field_2800 + 6);
				upgrades = true;
			}
		}
		int offset = upgrades ? 86 : 6;
		for (GuiTab slot : tabs) {
			if (slot.enabled()) {
				builder.drawSlotTab(this, field_2776 - 24, field_2800 + offset, slot.stack());
				offset += 24;
			}
		}

		final GuiBase<T> gui = this;
		getTab().ifPresent(guiTab -> builder.drawSlotConfigTips(gui, field_2776 + field_2792 / 2, field_2800 + 93, mouseX, mouseY, guiTab));

	}

	private void updateSlotDraw(boolean doDraw) {
		if (builtScreenHandler == null) {
			return;
		}
		for (class_1735 slot : builtScreenHandler.field_7761) {
			if (slot instanceof PlayerInventorySlot) {
				((PlayerInventorySlot) slot).doDraw = doDraw;
			}
		}
	}

	public boolean drawPlayerSlots() {
		return true;
	}

	public boolean tryAddUpgrades() {
		return true;
	}

	@Environment(EnvType.CLIENT)
	@Override
	protected void method_2388(int mouseX, int mouseY) {
		drawTitle();
		getTab().ifPresent(guiTab -> guiTab.draw(mouseX, mouseY));
	}

	@Override
	public void method_25394(int mouseX, int mouseY, float partialTicks) {
		super.method_25394(mouseX, mouseY, partialTicks);
		this.method_2380(mouseX, mouseY);
	}

	@Override
	protected void method_2380(int mouseX, int mouseY) {
		if (method_2378(-25, 6, 24, 80, mouseX, mouseY) && upgrades) {
			List<String> list = new ArrayList<>();
			list.add(StringUtils.t("reborncore.gui.tooltip.upgrades"));
			method_25417(list, mouseX, mouseY);
			RenderSystem.disableLighting();
			RenderSystem.color4f(1, 1, 1, 1);
		}
		int offset = upgrades ? 82 : 0;
		for (GuiTab tab : tabs) {
			if (method_2378(-26, 6 + offset, 24, 23, mouseX, mouseY)) {
				method_25417(Collections.singletonList(StringUtils.t(tab.name())), mouseX, mouseY);
				RenderSystem.disableLighting();
				RenderSystem.color4f(1, 1, 1, 1);
			}
			offset += 24;
		}

		for (class_339 abstractButtonWidget : field_22791) {
			if (abstractButtonWidget.method_25367()) {
				abstractButtonWidget.method_25352(mouseX, mouseY);
				break;
			}
		}
		super.method_2380(mouseX, mouseY);
	}

	protected void drawTitle() {
		drawCentredString(StringUtils.t(be.method_11010().method_26204().method_9539()), 6, 4210752, Layer.FOREGROUND);
	}

	public void drawCentredString(String string, int y, int colour, Layer layer) {
		drawString(string, (field_2792 / 2 - getTextRenderer().method_1727(string) / 2), y, colour, layer);
	}

	protected void drawCentredString(String string, int y, int colour, int modifier, Layer layer) {
		drawString(string, (field_2792 / 2 - (getTextRenderer().method_1727(string)) / 2) + modifier, y, colour, layer);
	}

	public void drawString(String string, int x, int y, int colour, Layer layer) {
		int factorX = 0;
		int factorY = 0;
		if (layer == Layer.BACKGROUND) {
			factorX = this.field_2776;
			factorY = this.field_2800;
		}
		getTextRenderer().method_1729(string, x + factorX, y + factorY, colour);
		RenderSystem.color4f(1, 1, 1, 1);
	}

	public GuiButtonHologram addHologramButton(int x, int y, int id, Layer layer) {
		GuiButtonHologram buttonHologram = new GuiButtonHologram(x + this.field_2776, y + this.field_2800, this, layer, var1 -> {
		});
		method_25411(buttonHologram);
		return buttonHologram;
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
		if (getTab().map(guiTab -> guiTab.click(mouseX, mouseY, mouseButton)).orElse(false)) {
			return true;
		}
		return super.method_25402(mouseX, mouseY, mouseButton);
	}

	//	@Override
	//	protected void mouseClickMove(double mouseX, double mouseY, int clickedMouseButton, long timeSinceLastClick) {
	//		if (isConfigEnabled() && slotConfigType == SlotConfigType.ITEMS && getMachine().hasSlotConfig()) {
	//			GuiSlotConfiguration.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, this);
	//		}
	//		if (isConfigEnabled() && slotConfigType == SlotConfigType.FLUIDS && getMachine().showTankConfig()) {
	//			GuiFluidConfiguration.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, this);
	//		}
	//		super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
	//	}

	@Override
	public boolean method_25406(double mouseX, double mouseY, int state) {
		int offset = 0;
		if (!upgrades) {
			offset = 80;
		}
		for (GuiTab tab : tabs) {
			if (method_2378(-26, 84 - offset, 30, 23, mouseX, mouseY)) {
				if (selectedTab == tab) {
					closeSelectedTab();
				} else {
					selectedTab = tab;
				}
				SlotConfigGui.reset();
				break;
			}
			offset -= 24;
		}

		if (getTab().map(guiTab -> guiTab.mouseReleased(mouseX, mouseY, state)).orElse(false)) {
			return true;
		}
		return super.method_25406(mouseX, mouseY, state);
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (getTab().map(guiTab -> guiTab.keyPress(keyCode, scanCode, modifiers)).orElse(false)) {
			return true;
		}
		if (selectedTab != null && keyCode == GLFW.GLFW_KEY_ESCAPE) {
			closeSelectedTab();
			return true;
		}
		return super.method_25404(keyCode, scanCode, modifiers);
	}

	@Override
	public void method_25419() {
		closeSelectedTab();
		super.method_25419();
	}

	@Nullable
	public MachineBaseBlockEntity getMachine() {
		return (MachineBaseBlockEntity) be;
	}

	/**
	 * @param rectX      int Top left corner of region
	 * @param rectY      int Top left corner of region
	 * @param rectWidth  int Width of region
	 * @param rectHeight int Height of region
	 * @param pointX     int Mouse pointer
	 * @param pointY     int Mouse pointer
	 * @return boolean Returns true if mouse pointer is in region specified
	 */
	public boolean isPointInRect(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
		return super.method_2378(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
	}

	public enum Layer {
		BACKGROUND, FOREGROUND
	}

	public interface FluidCellProvider {
		class_1799 provide(class_3611 fluid);
	}

	public boolean isConfigEnabled() {
		return be instanceof MachineBaseBlockEntity && builtScreenHandler != null;
	}

	public int getGuiLeft() {
		return field_2776;
	}

	public int getGuiTop() {
		return field_2800;
	}

	public class_310 getMinecraft() {
		// Just to stop complains from IDEA
		if (field_22787 == null) {
			throw new NullPointerException("Minecraft client is null.");
		}
		return this.field_22787;
	}

	public class_327 getTextRenderer() {
		return this.field_22793;
	}

	public Optional<GuiTab> getTab() {
		if (!isConfigEnabled()) {
			return Optional.empty();
		}
		return Optional.ofNullable(selectedTab);
	}

	public boolean isTabOpen() {
		return selectedTab != null;
	}

	public boolean hideGuiElements() {
		return selectedTab != null && selectedTab.hideGuiElements();
	}

	public void closeSelectedTab() {
		selectedTab = null;
	}

	@Override
	protected boolean method_2381(double mouseX, double mouseY, int left, int top, int mouseButton) {
		//Expanded the width to allow for the upgrades
		return super.method_2381(mouseX + 40, mouseY, left + 40, top, mouseButton);
	}
}
