/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui;

import net.minecraft.class_1799;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_918;
import org.lwjgl.opengl.GL11;
import reborncore.common.util.Color;

public class GuiButtonItemTexture extends class_4185 {

	public int textureU;
	public int textureV;
	public class_1799 itemstack;
	public String LINKED_PAGE;
	public String NAME;

	public GuiButtonItemTexture(int xPos, int yPos, int u, int v, int width, int height, class_1799 stack,
	                            String linkedPage, String name, class_4185.class_4241 pressAction) {
		super(xPos, yPos, width, height, "_", pressAction);
		textureU = u;
		textureV = v;
		itemstack = stack;
		NAME = name;
		this.LINKED_PAGE = linkedPage;
	}

	@Override
	public void method_25394(int mouseX, int mouseY, float ticks) {
		if (this.field_22764) {
			class_310 mc = class_310.method_1551();
			boolean flag = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758
				&& mouseY < this.field_22761 + this.field_22759;
			mc.method_1531().method_22813(field_22757);
			int u = textureU;
			int v = textureV;
			if (flag) {
				u += mc.field_1772.method_1727(this.NAME) + 25;
				v += mc.field_1772.method_1727(this.NAME) + 25;
				GL11.glPushMatrix();
				GL11.glColor4f(0f, 0f, 0f, 1f);
				this.method_25302(this.field_22760, this.field_22761, u, v, mc.field_1772.method_1727(this.NAME) + 25, field_22759);
				GL11.glPopMatrix();
			}
			GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
			GL11.glEnable(32826);
			class_308.method_22890();
			class_918 itemRenderer = class_310.method_1551().method_1480();
			itemRenderer.method_4010(itemstack, this.field_22760, this.field_22761);
			this.method_25303(mc.field_1772, this.NAME, this.field_22760 + 20, this.field_22761 + 3,
			                Color.WHITE.getColor());
		}
	}

}
